/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.flow;

import boofcv.alg.flow.HornSchunck;
import boofcv.struct.flow.ImageFlow;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageType;

public class HornSchunck_U8
extends HornSchunck<GrayU8, GrayS16> {
    public HornSchunck_U8(float alpha, int numIterations) {
        super(alpha, numIterations, ImageType.SB_S16);
    }

    @Override
    protected void computeDerivX(GrayU8 image1, GrayU8 image2, GrayS16 derivX) {
        int y;
        int w = image1.width - 1;
        int h = image1.height - 1;
        for (y = 0; y < h; ++y) {
            int index1 = image1.startIndex + y * image1.stride;
            int index2 = image2.startIndex + y * image2.stride;
            int indexX = derivX.startIndex + y * derivX.stride;
            int x = 0;
            while (x < w) {
                int d0 = (image1.data[index1 + 1] & 0xFF) - (image1.data[index1] & 0xFF);
                int d2 = (image2.data[index2 + 1] & 0xFF) - (image2.data[index2] & 0xFF);
                int d1 = (image1.data[index1 + 1 + image1.stride] & 0xFF) - (image1.data[index1 + image1.stride] & 0xFF);
                int d3 = (image2.data[index2 + 1 + image2.stride] & 0xFF) - (image2.data[index2 + image2.stride] & 0xFF);
                derivX.data[indexX] = (short)((d0 + d1 + d2 + d3) / 4);
                ++x;
                ++index1;
                ++index2;
                ++indexX;
            }
        }
        for (y = 0; y < image1.height; ++y) {
            derivX.unsafe_set(w, y, 0);
        }
        for (int x = 0; x < w; ++x) {
            int d0 = image1.unsafe_get(x + 1, h) - image1.unsafe_get(x, h);
            int d1 = image2.unsafe_get(x + 1, h) - image2.unsafe_get(x, h);
            derivX.unsafe_set(x, h, (d0 + d1) / 2);
        }
    }

    @Override
    protected void computeDerivY(GrayU8 image1, GrayU8 image2, GrayS16 derivY) {
        int y;
        int w = image1.width - 1;
        int h = image1.height - 1;
        for (y = 0; y < h; ++y) {
            int index1 = image1.startIndex + y * image1.stride;
            int index2 = image2.startIndex + y * image2.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            int x = 0;
            while (x < w) {
                int d0 = (image1.data[index1 + image1.stride] & 0xFF) - (image1.data[index1] & 0xFF);
                int d2 = (image2.data[index2 + image2.stride] & 0xFF) - (image2.data[index2] & 0xFF);
                int d1 = (image1.data[index1 + 1 + image1.stride] & 0xFF) - (image1.data[index1 + 1] & 0xFF);
                int d3 = (image2.data[index2 + 1 + image2.stride] & 0xFF) - (image2.data[index2 + 1] & 0xFF);
                derivY.data[indexY] = (short)((d0 + d1 + d2 + d3) / 4);
                ++x;
                ++index1;
                ++index2;
                ++indexY;
            }
        }
        for (y = 0; y < h; ++y) {
            int d0 = image1.unsafe_get(w, y + 1) - image1.unsafe_get(w, y);
            int d1 = image2.unsafe_get(w, y + 1) - image2.unsafe_get(w, y);
            derivY.unsafe_set(w, y, (d0 + d1) / 2);
        }
        for (int x = 0; x < w; ++x) {
            derivY.unsafe_set(x, h, 0);
        }
    }

    @Override
    protected void computeDerivT(GrayU8 image1, GrayU8 image2, GrayS16 difference) {
        int y;
        int w = image1.width - 1;
        int h = image1.height - 1;
        for (y = 0; y < h; ++y) {
            int index1 = image1.startIndex + y * image1.stride;
            int index2 = image2.startIndex + y * image2.stride;
            int indexDiff = difference.startIndex + y * difference.stride;
            int x = 0;
            while (x < w) {
                int d0 = (image2.data[index2] & 0xFF) - (image1.data[index1] & 0xFF);
                int d1 = (image2.data[index2 + 1] & 0xFF) - (image1.data[index1 + 1] & 0xFF);
                int d2 = (image2.data[index2 + image2.stride] & 0xFF) - (image1.data[index1 + image1.stride] & 0xFF);
                int d3 = (image2.data[index2 + 1 + image2.stride] & 0xFF) - (image1.data[index1 + 1 + image1.stride] & 0xFF);
                difference.data[indexDiff] = (short)((d0 + d1 + d2 + d3) / 4);
                ++x;
                ++index1;
                ++index2;
                ++indexDiff;
            }
        }
        for (y = 0; y < image1.height; ++y) {
            HornSchunck_U8.borderDerivT(image1, image2, difference, w, y);
        }
        for (int x = 0; x < w; ++x) {
            HornSchunck_U8.borderDerivT(image1, image2, difference, x, h);
        }
    }

    protected static void borderDerivT(GrayU8 imageA, GrayU8 imageB, GrayS16 difference, int x, int y) {
        float d0 = HornSchunck_U8.getBorderT(imageA, imageB, x, y);
        float d1 = HornSchunck_U8.getBorderT(imageA, imageB, x + 1, y);
        float d2 = HornSchunck_U8.getBorderT(imageA, imageB, x, y + 1);
        float d3 = HornSchunck_U8.getBorderT(imageA, imageB, x + 1, y + 1);
        difference.unsafe_set(x, y, (int)((short)((d0 + d1 + d2 + d3) / 4.0f)));
    }

    protected static float getBorderT(GrayU8 imageA, GrayU8 imageB, int x, int y) {
        if (x < 0) {
            x = 0;
        } else if (x >= imageA.width) {
            x = imageA.width - 1;
        }
        if (y < 0) {
            y = 0;
        } else if (y >= imageA.height) {
            y = imageA.height - 1;
        }
        return imageB.unsafe_get(x, y) - imageA.unsafe_get(x, y);
    }

    @Override
    protected void findFlow(GrayS16 derivX, GrayS16 derivY, GrayS16 derivT, ImageFlow output) {
        int N = output.width * output.height;
        for (int iter = 0; iter < this.numIterations; ++iter) {
            HornSchunck_U8.borderAverageFlow(output, this.averageFlow);
            HornSchunck_U8.innerAverageFlow(output, this.averageFlow);
            for (int i = 0; i < N; ++i) {
                float dx = derivX.data[i];
                float dy = derivY.data[i];
                float dt = derivT.data[i];
                ImageFlow.D aveFlow = this.averageFlow.data[i];
                float u = aveFlow.x;
                float v = aveFlow.y;
                ImageFlow.D flow = output.data[i];
                float r = (dx * u + dy * v + dt) / (this.alpha2 + dx * dx + dy * dy);
                flow.x = u - dx * r;
                flow.y = v - dy * r;
            }
        }
    }
}

