/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker;

import boofcv.abst.tracker.PointTrack;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class PruneCloseTracks<T> {
    private int radius;
    private int gridWidth;
    private int gridHeight;
    private T[] trackImage = new Object[0];
    private boolean[] dropImage = new boolean[0];
    private TrackInfo<T> trackInfo;
    Comparator<T> ambiguityResolver = (a, b) -> Long.compare(this.trackInfo.getID(b), this.trackInfo.getID(a));
    private Point2D_F64 candidatePt = new Point2D_F64();
    private Point2D_F64 currentPt = new Point2D_F64();

    public PruneCloseTracks(int radius, TrackInfo<T> trackInfo) {
        this.radius = radius;
        this.trackInfo = trackInfo;
    }

    public void init(int imgWidth, int imgHeight) {
        this.gridWidth = imgWidth / this.radius + 1;
        this.gridHeight = imgHeight / this.radius + 1;
        int N = this.gridWidth * this.gridHeight;
        if (this.trackImage.length < N) {
            this.trackImage = new Object[N];
            this.dropImage = new boolean[N];
        }
    }

    public void process(List<T> tracks, List<T> dropTracks) {
        dropTracks.clear();
        double tol = this.radius * this.radius;
        int w = this.gridWidth;
        int h = this.gridHeight;
        Arrays.fill(this.dropImage, 0, w * h, false);
        for (int i = 0; i < tracks.size(); ++i) {
            T candidate = tracks.get(i);
            this.trackInfo.getLocation(candidate, this.candidatePt);
            long candidateID = this.trackInfo.getID(candidate);
            int cx = (int)(this.candidatePt.x / (double)this.radius);
            int cy = (int)(this.candidatePt.y / (double)this.radius);
            int x0 = cx - 1;
            int x1 = cx + 2;
            int y0 = cy - 1;
            int y1 = cy + 2;
            if (x0 < 0) {
                x0 = 0;
            }
            if (x1 > w) {
                x1 = w;
            }
            if (y0 < 0) {
                y0 = 0;
            }
            if (y1 > h) {
                y1 = h;
            }
            int centerIndex = cy * w + cx;
            boolean candidateDropped = false;
            for (int y = y0; y < y1; ++y) {
                for (int x = x0; x < x1; ++x) {
                    int index = y * w + x;
                    T current = this.trackImage[index];
                    if (current == null) continue;
                    this.trackInfo.getLocation(current, this.currentPt);
                    if (this.currentPt.distance2((GeoTuple2D_F64)this.candidatePt) > tol) continue;
                    int result = this.ambiguityResolver.compare(candidate, current);
                    if (result < 0) {
                        candidateDropped = true;
                        continue;
                    }
                    if (result == 0 && this.trackInfo.getID(current) < candidateID) {
                        candidateDropped = true;
                        continue;
                    }
                    if (this.dropImage[index]) continue;
                    dropTracks.add(this.trackImage[index]);
                    this.dropImage[index] = true;
                }
            }
            if (candidateDropped) {
                dropTracks.add(candidate);
            }
            if (this.trackImage[centerIndex] != null && candidateDropped) continue;
            this.trackImage[centerIndex] = candidate;
            this.dropImage[centerIndex] = candidateDropped;
        }
        Arrays.fill(this.trackImage, 0, w * h, null);
    }

    public static PruneCloseTracks<PointTrack> prunePointTrack(int radius) {
        return new PruneCloseTracks<PointTrack>(radius, new TrackInfo<PointTrack>(){

            @Override
            public void getLocation(PointTrack track, Point2D_F64 location) {
                location.set(track.pixel);
            }

            @Override
            public long getID(PointTrack track) {
                return track.featureId;
            }
        });
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setAmbiguityResolver(Comparator<T> ambiguityResolver) {
        this.ambiguityResolver = ambiguityResolver;
    }

    public static interface TrackInfo<T> {
        public void getLocation(T var1, Point2D_F64 var2);

        public long getID(T var1);
    }
}

