/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.combined;

import boofcv.alg.interpolate.InterpolateRectangle;
import boofcv.alg.tracker.klt.ConfigKlt;
import boofcv.alg.tracker.klt.KltTrackFault;
import boofcv.alg.tracker.klt.KltTracker;
import boofcv.alg.tracker.klt.PyramidKltFeature;
import boofcv.alg.tracker.klt.PyramidKltTracker;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.image.ImageGray;
import boofcv.struct.pyramid.ImagePyramid;

public class PyramidKltForCombined<I extends ImageGray<I>, D extends ImageGray<D>> {
    public ConfigKlt config;
    public int featureRadius;
    protected int numLevels = -1;
    protected PyramidKltTracker<I, D> tracker;

    public PyramidKltForCombined(ConfigKlt config, int featureRadius, Class<I> inputType, Class<D> derivType) {
        this.config = config;
        this.featureRadius = featureRadius;
        InterpolateRectangle interpInput = FactoryInterpolation.bilinearRectangle(inputType);
        InterpolateRectangle interpDeriv = FactoryInterpolation.bilinearRectangle(derivType);
        KltTracker klt = new KltTracker(interpInput, interpDeriv, config);
        this.tracker = new PyramidKltTracker(klt);
    }

    protected PyramidKltForCombined() {
    }

    public void setDescription(float x, float y, PyramidKltFeature ret) {
        ret.setPosition(x, y);
        this.tracker.setDescription(ret);
    }

    public void setInputs(ImagePyramid<I> image, D[] derivX, D[] derivY) {
        if (this.numLevels == -1) {
            this.numLevels = image.getNumLayers();
        } else if (this.numLevels != image.getNumLayers()) {
            throw new IllegalArgumentException("Number of levels pyramid changed!");
        }
        this.tracker.setImage((ImagePyramid)image, (ImageGray[])derivX, (ImageGray[])derivY);
    }

    public boolean performTracking(PyramidKltFeature feature) {
        KltTrackFault result = this.tracker.track(feature);
        if (result != KltTrackFault.SUCCESS) {
            return false;
        }
        this.tracker.setDescription(feature);
        return true;
    }

    public PyramidKltFeature createNewTrack() {
        return new PyramidKltFeature(this.numLevels, this.featureRadius);
    }
}

