/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.associate;

import boofcv.abst.feature.associate.Associate;
import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.alg.feature.associate.AssociateUniqueByScoreAlg;
import boofcv.alg.feature.associate.FindUnassociated;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.MatchScoreType;
import georegression.struct.point.Point2D_F64;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;

public class EnforceUniqueByScore<A extends Associate>
implements Associate {
    protected AssociateUniqueByScoreAlg uniqueByScore;
    protected A association;
    protected FindUnassociated unassociated = new FindUnassociated();
    protected int numSource;
    protected int numDestination;

    public EnforceUniqueByScore(A association, boolean checkSource, boolean checkDestination) {
        this.association = association;
        checkSource = checkSource && !association.uniqueSource();
        checkDestination = checkDestination && !association.uniqueDestination();
        this.uniqueByScore = new AssociateUniqueByScoreAlg(association.getScoreType(), checkSource, checkDestination);
    }

    @Override
    public void associate() {
        this.association.associate();
    }

    @Override
    public FastAccess<AssociatedIndex> getMatches() {
        FastAccess<AssociatedIndex> matches = this.association.getMatches();
        this.uniqueByScore.process(matches, this.numSource, this.numDestination);
        return this.uniqueByScore.getMatches();
    }

    @Override
    public DogArray_I32 getUnassociatedSource() {
        return this.unassociated.checkSource(this.uniqueByScore.getMatches(), this.numSource);
    }

    @Override
    public DogArray_I32 getUnassociatedDestination() {
        return this.unassociated.checkDestination(this.uniqueByScore.getMatches(), this.numDestination);
    }

    @Override
    public void setMaxScoreThreshold(double score) {
        this.association.setMaxScoreThreshold(score);
    }

    @Override
    public MatchScoreType getScoreType() {
        return this.association.getScoreType();
    }

    @Override
    public boolean uniqueSource() {
        return this.association.uniqueSource() || this.uniqueByScore.checkSource();
    }

    @Override
    public boolean uniqueDestination() {
        return this.association.uniqueDestination() || this.uniqueByScore.checkDestination();
    }

    public static class Describe2D<Desc>
    extends EnforceUniqueByScore<AssociateDescription2D<Desc>>
    implements AssociateDescription2D<Desc> {
        public Describe2D(AssociateDescription2D<Desc> alg, boolean checkSource, boolean checkDestination) {
            super(alg, checkSource, checkDestination);
        }

        @Override
        public void initialize(int imageWidth, int imageHeight) {
            ((AssociateDescription2D)this.association).initialize(imageWidth, imageHeight);
        }

        @Override
        public void setSource(FastAccess<Point2D_F64> location, FastAccess<Desc> listSrc) {
            ((AssociateDescription2D)this.association).setSource(location, listSrc);
            this.numSource = listSrc.size;
        }

        @Override
        public void setDestination(FastAccess<Point2D_F64> location, FastAccess<Desc> listDst) {
            ((AssociateDescription2D)this.association).setDestination(location, listDst);
            this.numDestination = listDst.size;
        }
    }

    public static class Describe<Desc>
    extends EnforceUniqueByScore<AssociateDescription<Desc>>
    implements AssociateDescription<Desc> {
        public Describe(AssociateDescription<Desc> alg, boolean checkSource, boolean checkDestination) {
            super(alg, checkSource, checkDestination);
        }

        @Override
        public void setSource(FastAccess<Desc> listSrc) {
            ((AssociateDescription)this.association).setSource(listSrc);
            this.numSource = listSrc.size;
        }

        @Override
        public void setDestination(FastAccess<Desc> listDst) {
            ((AssociateDescription)this.association).setDestination(listDst);
            this.numDestination = listDst.size;
        }
    }
}

