/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.associate;

import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.alg.feature.associate.AssociateGreedyBase2D;
import boofcv.alg.feature.associate.FindUnassociated;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.MatchScoreType;
import georegression.struct.point.Point2D_F64;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F64;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;

public class WrapAssociateGreedy2D<D>
implements AssociateDescription2D<D> {
    AssociateGreedyBase2D<D> alg;
    DogArray<AssociatedIndex> matches = new DogArray(AssociatedIndex::new);
    DogArray_I32 unassocSrc = new DogArray_I32();
    FindUnassociated unassociated = new FindUnassociated();
    private int sizeDst;

    public WrapAssociateGreedy2D(AssociateGreedyBase2D<D> alg) {
        this.alg = alg;
    }

    @Override
    public void initialize(int imageWidth, int imageHeight) {
        this.alg.init(imageWidth, imageHeight);
    }

    @Override
    public void setSource(FastAccess<Point2D_F64> location, FastAccess<D> descriptions) {
        this.alg.setSource(location, descriptions);
    }

    @Override
    public void setDestination(FastAccess<Point2D_F64> location, FastAccess<D> descriptions) {
        this.alg.setDestination(location, descriptions);
        this.sizeDst = location.size;
    }

    @Override
    public void associate() {
        this.unassocSrc.reset();
        this.alg.associate();
        DogArray_I32 pairs = this.alg.getPairs();
        DogArray_F64 score = this.alg.getFitQuality();
        this.matches.reset();
        for (int i = 0; i < pairs.size; ++i) {
            int dst = pairs.data[i];
            if (dst >= 0) {
                ((AssociatedIndex)this.matches.grow()).setTo(i, dst, score.data[i]);
                continue;
            }
            this.unassocSrc.add(i);
        }
    }

    public DogArray<AssociatedIndex> getMatches() {
        return this.matches;
    }

    @Override
    public DogArray_I32 getUnassociatedSource() {
        return this.unassocSrc;
    }

    @Override
    public DogArray_I32 getUnassociatedDestination() {
        return this.unassociated.checkDestination((FastAccess<AssociatedIndex>)this.matches, this.sizeDst);
    }

    @Override
    public void setMaxScoreThreshold(double score) {
        this.alg.setMaxFitError(score);
    }

    @Override
    public MatchScoreType getScoreType() {
        return this.alg.getScore().getScoreType();
    }

    @Override
    public boolean uniqueSource() {
        return true;
    }

    @Override
    public boolean uniqueDestination() {
        return this.alg.isBackwardsValidation();
    }
}

