/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.associate;

import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.alg.feature.associate.FindUnassociated;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.MatchScoreType;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;

public abstract class AssociateNearestNeighbor<D>
implements AssociateDescription<D> {
    NearestNeighbor<D> alg;
    FastAccess<D> listDst;
    int sizeSrc;
    boolean ratioUsesSqrt = true;
    double scoreRatioThreshold = 1.0;
    protected final DogArray<AssociatedIndex> matchesAll = new DogArray(100, AssociatedIndex::new);
    private FindUnassociated unassociated = new FindUnassociated();
    double maxDistance = -1.0;

    protected AssociateNearestNeighbor(NearestNeighbor<D> alg) {
        this.alg = alg;
    }

    @Override
    public void setSource(FastAccess<D> listSrc) {
        this.sizeSrc = listSrc.size;
        this.alg.setPoints(listSrc.toList(), true);
    }

    @Override
    public void setDestination(FastAccess<D> listDst) {
        this.listDst = listDst;
    }

    public DogArray<AssociatedIndex> getMatches() {
        return this.matchesAll;
    }

    @Override
    public DogArray_I32 getUnassociatedSource() {
        return this.unassociated.checkSource((FastAccess<AssociatedIndex>)this.matchesAll, this.sizeSrc);
    }

    @Override
    public DogArray_I32 getUnassociatedDestination() {
        return this.unassociated.checkDestination((FastAccess<AssociatedIndex>)this.matchesAll, this.listDst.size());
    }

    @Override
    public void setMaxScoreThreshold(double score) {
        this.maxDistance = score;
    }

    @Override
    public MatchScoreType getScoreType() {
        return MatchScoreType.NORM_ERROR;
    }

    @Override
    public boolean uniqueSource() {
        return false;
    }

    @Override
    public boolean uniqueDestination() {
        return true;
    }

    public boolean isRatioUsesSqrt() {
        return this.ratioUsesSqrt;
    }

    public void setRatioUsesSqrt(boolean ratioUsesSqrt) {
        this.ratioUsesSqrt = ratioUsesSqrt;
    }

    public double getScoreRatioThreshold() {
        return this.scoreRatioThreshold;
    }

    public void setScoreRatioThreshold(double scoreRatioThreshold) {
        this.scoreRatioThreshold = scoreRatioThreshold;
    }
}

