/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detdesc;

import boofcv.abst.feature.detect.extract.NonMaxLimiter;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.describe.DescribePointSift;
import boofcv.alg.feature.detect.interest.SiftDetector;
import boofcv.alg.feature.detect.interest.SiftScaleSpace;
import boofcv.alg.feature.detect.selector.FeatureSelectLimitIntensity;
import boofcv.alg.feature.orientation.OrientationHistogramSift;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.struct.feature.ScalePoint;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F64;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastArray;

public class CompleteSift
extends SiftDetector {
    OrientationHistogramSift<GrayF32> orientation;
    DescribePointSift<GrayF32> describe;
    DogArray<TupleDesc_F64> features;
    FastArray<ScalePoint> locations = new FastArray(ScalePoint.class);
    DogArray_F64 orientations = new DogArray_F64();
    ImageGradient<GrayF32, GrayF32> gradient = FactoryDerivative.three(GrayF32.class, null);
    GrayF32 derivX = new GrayF32(1, 1);
    GrayF32 derivY = new GrayF32(1, 1);

    public CompleteSift(SiftScaleSpace scaleSpace, FeatureSelectLimitIntensity<ScalePoint> selectFeaturesAll, double edgeR, NonMaxLimiter extractor, OrientationHistogramSift<GrayF32> orientation, DescribePointSift<GrayF32> describe) {
        super(scaleSpace, selectFeaturesAll, edgeR, extractor);
        this.orientation = orientation;
        this.describe = describe;
        int dof = describe.getDescriptorLength();
        this.features = new DogArray(() -> new TupleDesc_F64(dof));
    }

    @Override
    public void process(GrayF32 input) {
        this.features.reset();
        this.locations.reset();
        this.orientations.reset();
        super.process(input);
    }

    @Override
    protected void detectFeatures(int scaleIndex) {
        GrayF32 input = this.scaleSpace.getImageScale(scaleIndex);
        this.derivX.reshape(input.width, input.height);
        this.derivY.reshape(input.width, input.height);
        this.gradient.process((ImageBase)input, (ImageBase)this.derivX, (ImageBase)this.derivY);
        this.orientation.setImageGradient(this.derivX, this.derivY);
        this.describe.setImageGradient(this.derivX, this.derivY);
        super.detectFeatures(scaleIndex);
    }

    @Override
    protected void handleDetection(ScalePoint p) {
        double localX = p.pixel.x / this.pixelScaleToInput;
        double localY = p.pixel.y / this.pixelScaleToInput;
        double localSigma = p.scale / this.pixelScaleToInput;
        this.orientation.process(localX, localY, localSigma);
        DogArray_F64 angles = this.orientation.getOrientations();
        for (int i = 0; i < angles.size; ++i) {
            this.describe.process(localX, localY, localSigma, angles.get(i), (TupleDesc_F64)this.features.grow());
            this.orientations.add(angles.get(i));
            this.locations.add((Object)p);
        }
    }

    public FastAccess<ScalePoint> getLocations() {
        return this.locations;
    }

    public FastAccess<TupleDesc_F64> getDescriptions() {
        return this.features;
    }

    public DogArray_F64 getOrientations() {
        return this.orientations;
    }

    public int getDescriptorLength() {
        return this.describe.getDescriptorLength();
    }
}

