/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.detect.selector;

import boofcv.alg.feature.detect.selector.ConvertLimitToIntensity;
import boofcv.alg.feature.detect.selector.FeatureSelectLimit;
import boofcv.alg.feature.detect.selector.FeatureSelectLimitIntensity;
import boofcv.alg.feature.detect.selector.FeatureSelectN;
import boofcv.alg.feature.detect.selector.FeatureSelectNBest;
import boofcv.alg.feature.detect.selector.FeatureSelectRandom;
import boofcv.alg.feature.detect.selector.FeatureSelectUniform;
import boofcv.alg.feature.detect.selector.FeatureSelectUniformBest;
import boofcv.alg.feature.detect.selector.SampleIntensity;
import boofcv.alg.feature.detect.selector.SampleIntensityImage;
import boofcv.factory.feature.detect.selector.ConfigSelectLimit;
import georegression.struct.GeoTuple;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I16;
import org.jetbrains.annotations.Nullable;

public class FactorySelectLimit {
    public static <Point extends GeoTuple<Point>> FeatureSelectLimitIntensity<Point> intensity(@Nullable ConfigSelectLimit config, Class<Point> type) {
        FeatureSelectLimitIntensity<Point> ret = FactorySelectLimit.intensity(config);
        ret.setSampler(FactorySelectLimit.imageSampler(type));
        return ret;
    }

    public static <Point> FeatureSelectLimitIntensity<Point> intensity(@Nullable ConfigSelectLimit config) {
        FeatureSelectLimitIntensity featureSelectLimitIntensity;
        if (config == null) {
            config = new ConfigSelectLimit();
        }
        switch (config.type) {
            case SELECT_N: {
                featureSelectLimitIntensity = new FeatureSelectNBest();
                break;
            }
            case RANDOM: {
                featureSelectLimitIntensity = new ConvertLimitToIntensity(new FeatureSelectRandom(config.randomSeed));
                break;
            }
            case UNIFORM: {
                featureSelectLimitIntensity = new FeatureSelectUniformBest();
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        return featureSelectLimitIntensity;
    }

    public static <Point extends GeoTuple<Point>> SampleIntensity<Point> imageSampler(Class<Point> type) {
        if (type == Point2D_I16.class) {
            return new SampleIntensityImage.I16();
        }
        if (type == Point2D_F32.class) {
            return new SampleIntensityImage.F32();
        }
        if (type == Point2D_F64.class) {
            return new SampleIntensityImage.F64();
        }
        throw new IllegalArgumentException("Unknown point type " + type.getSimpleName());
    }

    public static <Point extends GeoTuple<Point>> FeatureSelectLimit<Point> spatial(@Nullable ConfigSelectLimit config, Class<Point> type) {
        FeatureSelectLimit featureSelectLimit;
        if (config == null) {
            config = new ConfigSelectLimit();
        }
        switch (config.type) {
            case SELECT_N: {
                featureSelectLimit = new FeatureSelectN();
                break;
            }
            case RANDOM: {
                featureSelectLimit = new FeatureSelectRandom(config.randomSeed);
                break;
            }
            case UNIFORM: {
                FeatureSelectUniform ret;
                if (type == Point2D_I16.class) {
                    ret = new FeatureSelectUniform.I16();
                } else if (type == Point2D_F32.class) {
                    ret = new FeatureSelectUniform.F32();
                } else if (type == Point2D_F64.class) {
                    ret = new FeatureSelectUniform.F64();
                } else {
                    throw new IllegalArgumentException("Unknown point type " + type.getSimpleName());
                }
                featureSelectLimit = ret;
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        return featureSelectLimit;
    }
}

