/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.tracker;

import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.tracker.ConfigTrackerHybrid;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.alg.interpolate.InterpolateRectangle;
import boofcv.alg.tracker.hybrid.HybridTrackerScalePoint;
import boofcv.alg.tracker.hybrid.PyramidKltForHybrid;
import boofcv.alg.tracker.klt.ConfigKlt;
import boofcv.alg.tracker.klt.ConfigPKlt;
import boofcv.alg.tracker.klt.KltTracker;
import boofcv.alg.tracker.klt.PyramidKltTracker;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageGray;
import org.jetbrains.annotations.Nullable;

public class FactoryTrackerAlg {
    public static <I extends ImageGray<I>, D extends ImageGray<D>> KltTracker<I, D> klt(@Nullable ConfigKlt config, Class<I> imageType, Class<D> derivType) {
        if (config == null) {
            config = new ConfigKlt();
        }
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(imageType);
        }
        InterpolateRectangle interpInput = FactoryInterpolation.bilinearRectangle(imageType);
        InterpolateRectangle interpDeriv = FactoryInterpolation.bilinearRectangle((Class)derivType);
        return new KltTracker(interpInput, interpDeriv, config);
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> PyramidKltTracker<I, D> kltPyramid(@Nullable ConfigKlt config, Class<I> imageType, Class<D> derivType) {
        if (config == null) {
            config = new ConfigKlt();
        }
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(imageType);
        }
        InterpolateRectangle interpInput = FactoryInterpolation.bilinearRectangle(imageType);
        InterpolateRectangle interpDeriv = FactoryInterpolation.bilinearRectangle((Class)derivType);
        KltTracker klt = new KltTracker(interpInput, interpDeriv, config);
        return new PyramidKltTracker(klt);
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>, Desc extends TupleDesc> HybridTrackerScalePoint<I, D, Desc> hybrid(DetectDescribePoint<I, Desc> detector, AssociateDescription2D<Desc> associate, int tooCloseRadius, @Nullable ConfigPKlt kltConfig, @Nullable ConfigTrackerHybrid configHybrid, Class<I> imageType, @Nullable Class<D> derivType) {
        if (configHybrid == null) {
            configHybrid = new ConfigTrackerHybrid();
        }
        if (kltConfig == null) {
            kltConfig = new ConfigPKlt();
        }
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(imageType);
        }
        PyramidKltForHybrid klt = new PyramidKltForHybrid(kltConfig.config, kltConfig.templateRadius, imageType, derivType);
        HybridTrackerScalePoint tracker = new HybridTrackerScalePoint(klt, detector, associate, tooCloseRadius);
        tracker.maxInactiveTracks = configHybrid.maxInactiveTracks;
        return tracker;
    }
}

