/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.describe;

import boofcv.abst.feature.convert.ConvertTupleDesc;
import boofcv.abst.feature.convert.ConvertTupleDescPositive_F64_U8;
import boofcv.abst.feature.convert.ConvertTupleDescSigned_F64_S8;
import boofcv.abst.feature.convert.ConvertTupleDesc_F64_F32;
import boofcv.abst.feature.convert.ConvertTupleDoNothing;
import boofcv.factory.feature.describe.ConfigConvertTupleDesc;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.feature.TupleDesc_B;
import boofcv.struct.feature.TupleDesc_F32;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.feature.TupleDesc_S8;
import boofcv.struct.feature.TupleDesc_U8;

public class FactoryConvertTupleDesc {
    public static <A extends TupleDesc<A>, B extends TupleDesc<B>> ConvertTupleDesc<A, B> generic(ConfigConvertTupleDesc config, int numElements, Class<A> srcType) {
        if (config.outputData == ConfigConvertTupleDesc.DataType.NATIVE) {
            if (srcType == TupleDesc_F64.class) {
                return new ConvertTupleDoNothing(() -> new TupleDesc_F64(numElements));
            }
            if (srcType == TupleDesc_F32.class) {
                return new ConvertTupleDoNothing(() -> new TupleDesc_F32(numElements));
            }
            if (srcType == TupleDesc_B.class) {
                return new ConvertTupleDoNothing(() -> new TupleDesc_B(numElements));
            }
            throw new IllegalArgumentException("Add support for " + srcType.getName());
        }
        if (srcType == TupleDesc_F64.class) {
            ConvertTupleDesc<TupleDesc_F64, TupleDesc_F32> convertTupleDesc;
            switch (config.outputData) {
                case F32: {
                    convertTupleDesc = new ConvertTupleDesc_F64_F32(numElements);
                    break;
                }
                case U8: {
                    convertTupleDesc = new ConvertTupleDescPositive_F64_U8(numElements);
                    break;
                }
                case S8: {
                    convertTupleDesc = new ConvertTupleDescSigned_F64_S8(numElements);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported conversion");
                }
            }
            return convertTupleDesc;
        }
        throw new IllegalArgumentException("Add support for this new conversion: " + srcType.getSimpleName() + " -> " + (Object)((Object)config.outputData));
    }

    public static ConvertTupleDesc<TupleDesc_F64, TupleDesc_U8> positive_F64_U8(int numElements) {
        return new ConvertTupleDescPositive_F64_U8(numElements);
    }

    public static ConvertTupleDesc<TupleDesc_F64, TupleDesc_S8> real_F64_S8(int numElements) {
        return new ConvertTupleDescSigned_F64_S8(numElements);
    }
}

