/*
 * Copyright (c) 2021, Peter Abeles. All Rights Reserved.
 *
 * This file is part of BoofCV (http://boofcv.org).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package boofcv.alg.descriptor;

import boofcv.struct.feature.TupleDesc_F32;
import org.ddogleg.nn.alg.KdTreeDistance;

/**
 * Distance using {@link TupleDesc_F32} for a {@link org.ddogleg.nn.alg.KdTree}.
 *
 * @author Peter Abeles
 */
public class KdTreeTuple_F32 implements KdTreeDistance<TupleDesc_F32> {

	int N;

	public KdTreeTuple_F32( int n) {
		N = n;
	}

	@Override
	public double distance(TupleDesc_F32 a, TupleDesc_F32 b) {
		return DescriptorDistance.euclideanSq(a,b);
	}

	@Override
	public double valueAt(TupleDesc_F32 point, int index) {
		return point.data[index];
	}

	@Override
	public int length() {
		return N;
	}
}
