/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detdesc;

import boofcv.alg.feature.describe.DescribePointSift;
import boofcv.alg.feature.detect.interest.SiftDetector;
import boofcv.alg.feature.detect.interest.SiftScaleSpace;
import boofcv.alg.feature.detect.interest.UnrollSiftScaleSpaceGradient;
import boofcv.alg.feature.orientation.OrientationHistogramSift;
import boofcv.struct.feature.ScalePoint;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.GrayF32;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F64;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastArray;

public class CompleteSift {
    SiftScaleSpace scaleSpace;
    SiftDetector detector;
    OrientationHistogramSift<GrayF32> orientation;
    DescribePointSift<GrayF32> describe;
    DogArray<TupleDesc_F64> features;
    FastArray<ScalePoint> locations = new FastArray(ScalePoint.class);
    DogArray_F64 orientations = new DogArray_F64();
    UnrollSiftScaleSpaceGradient gradient = new UnrollSiftScaleSpaceGradient();

    public CompleteSift(SiftScaleSpace scaleSpace, SiftDetector detector, OrientationHistogramSift<GrayF32> orientation, DescribePointSift<GrayF32> describe) {
        this.scaleSpace = scaleSpace;
        this.detector = detector;
        this.orientation = orientation;
        this.describe = describe;
        int dof = describe.getDescriptorLength();
        this.features = new DogArray(() -> new TupleDesc_F64(dof));
    }

    public void process(GrayF32 input) {
        this.features.reset();
        this.locations.reset();
        this.orientations.reset();
        this.scaleSpace.process(input);
        this.detector.process(this.scaleSpace);
        this.gradient.process(this.scaleSpace);
        List<SiftDetector.SiftPoint> detections = this.detector.getDetections();
        this.describeDetections(detections);
    }

    protected void describeDetections(List<SiftDetector.SiftPoint> detections) {
        for (int detIdx = 0; detIdx < detections.size(); ++detIdx) {
            SiftDetector.SiftPoint p = detections.get(detIdx);
            GrayF32 derivX = this.gradient.getDerivX(p.octaveIdx, (byte)(p.scaleIdx - 1));
            GrayF32 derivY = this.gradient.getDerivY(p.octaveIdx, (byte)(p.scaleIdx - 1));
            this.orientation.setImageGradient(derivX, derivY);
            this.describe.setImageGradient(derivX, derivY);
            double pixelScaleToInput = this.scaleSpace.pixelScaleCurrentToInput(p.octaveIdx);
            double localX = p.pixel.x / pixelScaleToInput;
            double localY = p.pixel.y / pixelScaleToInput;
            double localSigma = p.scale / pixelScaleToInput;
            this.orientation.process(localX, localY, localSigma);
            DogArray_F64 angles = this.orientation.getOrientations();
            for (int angleIdx = 0; angleIdx < angles.size; ++angleIdx) {
                this.describe.process(localX, localY, localSigma, angles.get(angleIdx), (TupleDesc_F64)this.features.grow());
                this.orientations.add(angles.get(angleIdx));
                this.locations.add((Object)p);
            }
        }
    }

    public FastAccess<ScalePoint> getLocations() {
        return this.locations;
    }

    public FastAccess<TupleDesc_F64> getDescriptions() {
        return this.features;
    }

    public int getDescriptorLength() {
        return this.describe.getDescriptorLength();
    }

    public SiftScaleSpace getScaleSpace() {
        return this.scaleSpace;
    }

    public SiftDetector getDetector() {
        return this.detector;
    }

    public OrientationHistogramSift<GrayF32> getOrientation() {
        return this.orientation;
    }

    public DescribePointSift<GrayF32> getDescribe() {
        return this.describe;
    }

    public DogArray_F64 getOrientations() {
        return this.orientations;
    }
}

