/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.chess;

import boofcv.alg.feature.detect.chess.ChessboardCorner;
import boofcv.alg.feature.detect.chess.ChessboardCornerDistance;
import boofcv.alg.feature.detect.chess.DetectChessboardCornersX;
import boofcv.alg.filter.misc.AverageDownSampleOps;
import boofcv.alg.misc.ImageNormalization;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.GeoTuple2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.nn.FactoryNearestNeighbor;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.nn.alg.KdTreeDistance;
import org.ddogleg.struct.DogArray;

public class DetectChessboardCornersXPyramid<T extends ImageGray<T>> {
    public int pyramidTopSize = 100;
    public int searchMaxCount = 10;
    GrayF32 normalized = new GrayF32(1, 1);
    List<GrayF32> pyramid = new ArrayList<GrayF32>();
    public int radius = 7;
    public DetectChessboardCornersX detector;
    DogArray<PyramidLevel> featureLevels = new DogArray(PyramidLevel.class, () -> new PyramidLevel());
    public DogArray<ChessboardCorner> corners = new DogArray(ChessboardCorner::new);
    NearestNeighbor<ChessboardCorner> nn = FactoryNearestNeighbor.kdtree((KdTreeDistance)new ChessboardCornerDistance());
    NearestNeighbor.Search<ChessboardCorner> nnSearch = this.nn.createSearch();
    DogArray<NnData<ChessboardCorner>> nnResults = new DogArray(NnData::new);
    public ImageType<T> imageType;

    public DetectChessboardCornersXPyramid(DetectChessboardCornersX detector, ImageType<T> imageType) {
        this.detector = detector;
        this.imageType = imageType;
    }

    public DetectChessboardCornersXPyramid(ImageType<T> imageType) {
        this(new DetectChessboardCornersX(), imageType);
    }

    public void process(T input) {
        int level;
        float maxIntensityImage;
        this.constructPyramid(input);
        this.corners.reset();
        this.detector.considerMaxIntensityImage = maxIntensityImage = 0.0f;
        for (level = this.pyramid.size() - 1; level >= 0; --level) {
            double scale = Math.pow(2.0, level);
            this.detector.considerMaxIntensityImage = maxIntensityImage;
            this.detector.process(this.pyramid.get(level));
            maxIntensityImage = Math.max(maxIntensityImage, this.detector.maxIntensityImage);
            PyramidLevel featsLevel = (PyramidLevel)this.featureLevels.get(level);
            List<ChessboardCorner> corners = this.detector.getCorners();
            featsLevel.corners.resetResize(corners.size());
            for (int i = 0; i < corners.size(); ++i) {
                ChessboardCorner cf = corners.get(i);
                double x = cf.x * scale;
                double y = cf.y * scale;
                ChessboardCorner cl = (ChessboardCorner)((Object)featsLevel.corners.get(i));
                cl.first = true;
                cl.setTo(x, y, cf.orientation, cf.intensity);
                cl.contrast = cf.contrast;
                cl.levelMax = level;
                cl.level1 = level;
                cl.level2 = level;
            }
        }
        for (level = 0; level < this.pyramid.size(); ++level) {
            PyramidLevel level0 = (PyramidLevel)this.featureLevels.get(level);
            for (int upperLevel = level + 1; upperLevel < this.pyramid.size(); ++upperLevel) {
                PyramidLevel level1 = (PyramidLevel)this.featureLevels.get(upperLevel);
                this.considerLocalizingAtThisScale(level0.corners, level1.corners, upperLevel);
            }
        }
        for (int levelIdx = 0; levelIdx < this.pyramid.size(); ++levelIdx) {
            PyramidLevel level2 = (PyramidLevel)this.featureLevels.get(levelIdx);
            for (int i = 0; i < level2.corners.size; ++i) {
                ChessboardCorner c = (ChessboardCorner)((Object)level2.corners.get(i));
                if (!c.first) continue;
                ((ChessboardCorner)((Object)this.corners.grow())).setTo(c);
            }
        }
    }

    void considerLocalizingAtThisScale(DogArray<ChessboardCorner> corners0, DogArray<ChessboardCorner> corners1, int level1) {
        this.nn.setPoints(corners1.toList(), false);
        double searchRadius = 4 * this.radius * (level1 + 1);
        for (int cornerIdx = 0; cornerIdx < corners0.size; ++cornerIdx) {
            ChessboardCorner c0 = (ChessboardCorner)((Object)corners0.get(cornerIdx));
            this.nnSearch.findNearest((Object)c0, searchRadius, this.searchMaxCount, this.nnResults);
            if (this.nnResults.isEmpty()) continue;
            ChessboardCorner resultsMax = (ChessboardCorner)((Object)((NnData)this.nnResults.get((int)0)).point);
            for (int candidateIdx = 0; candidateIdx < this.nnResults.size; ++candidateIdx) {
                ChessboardCorner c1 = (ChessboardCorner)((Object)((NnData)this.nnResults.get((int)candidateIdx)).point);
                c1.first = false;
                if (!(c1.intensity > resultsMax.intensity)) continue;
                resultsMax = c1;
            }
            if (!c0.first) continue;
            double intensity1 = resultsMax.intensity / (1.0 + (double)resultsMax.level1);
            double intensity0 = c0.intensity / (1.0 + (double)c0.levelMax);
            if (intensity1 > intensity0) {
                if (c0.distance2((GeoTuple2D_F64)resultsMax) > (double)(this.radius * this.radius)) continue;
                int tmp = c0.level1;
                c0.setTo(resultsMax);
                c0.level1 = tmp;
                c0.first = true;
                continue;
            }
            c0.level2 = resultsMax.level2;
        }
    }

    void constructPyramid(T input) {
        ImageNormalization.maxAbsOfOne(input, (ImageGray)this.normalized, null);
        if (this.pyramid.size() == 0) {
            this.pyramid.add(this.normalized);
        } else {
            this.pyramid.set(0, this.normalized);
        }
        int pyramidTopSize = this.pyramidTopSize;
        if (pyramidTopSize != 0 && pyramidTopSize < (1 + 2 * this.radius) * 5) {
            pyramidTopSize = (1 + 2 * this.radius) * 5;
        }
        int levelIndex = 1;
        int divisor = 2;
        while (true) {
            GrayF32 level;
            int width = ((ImageGray)input).width / divisor;
            int height = ((ImageGray)input).height / divisor;
            if (pyramidTopSize == 0 || width < pyramidTopSize || height < pyramidTopSize) break;
            if (this.pyramid.size() <= levelIndex) {
                level = new GrayF32(width, height);
                this.pyramid.add(level);
            } else {
                level = this.pyramid.get(levelIndex);
                level.reshape(width, height);
            }
            AverageDownSampleOps.down((GrayF32)this.pyramid.get(levelIndex - 1), (int)2, (GrayF32)level);
            divisor *= 2;
            ++levelIndex;
        }
        while (this.pyramid.size() > levelIndex) {
            this.pyramid.remove(this.pyramid.size() - 1);
        }
        this.featureLevels.resize(this.pyramid.size());
    }

    public int getNumberOfLevels() {
        return this.pyramid.size();
    }

    public int getPyramidTopSize() {
        return this.pyramidTopSize;
    }

    public void setPyramidTopSize(int pyramidTopSize) {
        this.pyramidTopSize = pyramidTopSize;
    }

    public int getSearchMaxCount() {
        return this.searchMaxCount;
    }

    public void setSearchMaxCount(int searchMaxCount) {
        this.searchMaxCount = searchMaxCount;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public DetectChessboardCornersX getDetector() {
        return this.detector;
    }

    public DogArray<ChessboardCorner> getCorners() {
        return this.corners;
    }

    public ImageType<T> getImageType() {
        return this.imageType;
    }

    private static class PyramidLevel {
        DogArray<ChessboardCorner> corners = new DogArray(ChessboardCorner::new);

        private PyramidLevel() {
        }
    }
}

