/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.interest;

import boofcv.abst.feature.detect.interest.InterestPointScaleSpacePyramid;
import boofcv.abst.filter.ImageFunctionSparse;
import boofcv.abst.filter.derivative.AnyImageDerivative;
import boofcv.alg.feature.detect.interest.FastHessianFeatureDetector;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.struct.QueueCorner;
import boofcv.struct.feature.ScalePoint;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.pyramid.PyramidFloat;
import georegression.struct.point.Point2D_I16;
import java.util.ArrayList;
import java.util.List;

public class FeatureLaplacePyramid<T extends ImageGray<T>, D extends ImageGray<D>>
implements InterestPointScaleSpacePyramid<T> {
    private ImageFunctionSparse<T> sparseLaplace;
    private GeneralFeatureDetector<T, D> detector;
    private float baseThreshold;
    protected int spaceIndex = 0;
    protected List<Point2D_I16> maximums = new ArrayList<Point2D_I16>();
    protected List<ScalePoint> foundPoints = new ArrayList<ScalePoint>();
    protected AnyImageDerivative<T, D> computeDerivative;
    protected double scalePower;

    public FeatureLaplacePyramid(GeneralFeatureDetector<T, D> detector, ImageFunctionSparse<T> sparseLaplace, AnyImageDerivative<T, D> computeDerivative, double scalePower) {
        this.detector = detector;
        this.baseThreshold = detector.getThreshold();
        this.computeDerivative = computeDerivative;
        this.sparseLaplace = sparseLaplace;
        this.scalePower = scalePower;
    }

    @Override
    public void detect(PyramidFloat<T> ss) {
        this.spaceIndex = 0;
        this.foundPoints.clear();
        for (int i = 1; i < ss.getNumLayers() - 1; ++i) {
            this.spaceIndex = i;
            this.detectCandidateFeatures((ImageGray)ss.getLayer(i), ss.getSigma(i));
            this.findLocalScaleSpaceMax(ss, i);
        }
    }

    private void detectCandidateFeatures(T image, double sigma) {
        int i;
        QueueCorner q;
        float scaleThreshold = (float)((double)this.baseThreshold / Math.pow(sigma, this.scalePower));
        this.detector.setThreshold(scaleThreshold);
        this.computeDerivative.setInput(image);
        ImageGray derivX = null;
        ImageGray derivY = null;
        ImageGray derivXX = null;
        ImageGray derivYY = null;
        ImageGray derivXY = null;
        if (this.detector.getRequiresGradient()) {
            derivX = this.computeDerivative.getDerivative(new boolean[]{true});
            derivY = this.computeDerivative.getDerivative(new boolean[]{false});
        }
        if (this.detector.getRequiresHessian()) {
            derivXX = this.computeDerivative.getDerivative(new boolean[]{true, true});
            derivYY = this.computeDerivative.getDerivative(new boolean[]{false, false});
            derivXY = this.computeDerivative.getDerivative(new boolean[]{true, false});
        }
        this.detector.process(image, derivX, derivY, derivXX, derivYY, derivXY);
        List<Point2D_I16> m = this.maximums;
        m.clear();
        if (this.detector.isDetectMaximums()) {
            q = this.detector.getMaximums();
            for (i = 0; i < q.size; ++i) {
                m.add(((Point2D_I16)q.get(i)).copy());
            }
        }
        if (this.detector.isDetectMinimums()) {
            q = this.detector.getMinimums();
            for (i = 0; i < q.size; ++i) {
                m.add(((Point2D_I16)q.get(i)).copy());
            }
        }
    }

    protected void findLocalScaleSpaceMax(PyramidFloat<T> ss, int layerID) {
        List<Point2D_I16> candidates = this.maximums;
        float scale0 = (float)ss.scale[layerID - 1];
        float scale1 = (float)ss.scale[layerID];
        float scale2 = (float)ss.scale[layerID + 1];
        float sigma0 = (float)ss.getSigma(layerID - 1);
        float sigma1 = (float)ss.getSigma(layerID);
        float sigma2 = (float)ss.getSigma(layerID + 1);
        float ss0 = (float)(Math.pow(sigma0, 1.5) / (double)scale0);
        float ss1 = (float)(Math.pow(sigma1, 1.5) / (double)scale1);
        float ss2 = (float)(Math.pow(sigma2, 1.5) / (double)scale2);
        for (int canIdx = 0; canIdx < candidates.size(); ++canIdx) {
            Point2D_I16 c = candidates.get(canIdx);
            GrayF32 intensity = this.detector.getIntensity();
            float target = intensity.unsafe_get((int)c.x, (int)c.y);
            float x0 = intensity.unsafe_get(c.x - 1, (int)c.y);
            float x2 = intensity.unsafe_get(c.x + 1, (int)c.y);
            float y0 = intensity.unsafe_get((int)c.x, c.y - 1);
            float y2 = intensity.unsafe_get((int)c.x, c.y + 1);
            float fx = (float)c.x + FastHessianFeatureDetector.polyPeak(x0, target, x2);
            float fy = (float)c.y + FastHessianFeatureDetector.polyPeak(y0, target, y2);
            this.sparseLaplace.setImage((ImageGray)ss.getLayer(layerID));
            float val = ss1 * (float)this.sparseLaplace.compute((int)c.x, (int)c.y);
            float adj = Math.signum(val);
            int x02 = (int)((double)(fx * scale1 / scale0) + 0.5);
            int y02 = (int)((double)(fy * scale1 / scale0) + 0.5);
            int x22 = (int)((double)(fx * scale1 / scale2) + 0.5);
            int y22 = (int)((double)(fy * scale1 / scale2) + 0.5);
            if (!this.checkMax((ImageGray)ss.getLayer(layerID - 1), adj * ss0, val *= adj, x02, y02) || !this.checkMax((ImageGray)ss.getLayer(layerID + 1), adj * ss2, val, x22, y22)) continue;
            this.sparseLaplace.setImage((ImageGray)ss.getLayer(layerID - 1));
            float s0 = ss0 * (float)this.sparseLaplace.compute(x02, y02) * adj;
            this.sparseLaplace.setImage((ImageGray)ss.getLayer(layerID + 1));
            float s2 = ss2 * (float)this.sparseLaplace.compute(x22, y22) * adj;
            double sigmaInterp = FastHessianFeatureDetector.polyPeak(s0, val, s2);
            double adjSigma = sigmaInterp < 0.0 ? (double)sigma0 * -sigmaInterp + (1.0 + sigmaInterp) * (double)sigma1 : (double)sigma2 * sigmaInterp + (1.0 - sigmaInterp) * (double)sigma1;
            this.foundPoints.add(new ScalePoint(fx * scale1, fy * scale1, adjSigma));
        }
    }

    private boolean checkMax(T image, double adj, double bestScore, int c_x, int c_y) {
        this.sparseLaplace.setImage(image);
        boolean isMax = true;
        block0: for (int i = c_y - 1; i <= c_y + 1; ++i) {
            for (int j = c_x - 1; j <= c_x + 1; ++j) {
                double value = adj * this.sparseLaplace.compute(j, i);
                if (!(value >= bestScore)) continue;
                isMax = false;
                break block0;
            }
        }
        return isMax;
    }

    @Override
    public List<ScalePoint> getInterestPoints() {
        return this.foundPoints;
    }
}

