/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.background;

import boofcv.alg.interpolate.InterpolationType;
import boofcv.factory.background.BaseConfigBackground;

public class ConfigBackgroundGaussian
extends BaseConfigBackground {
    public float learnRate = 0.05f;
    public float threshold;
    public float initialVariance = Float.MIN_VALUE;
    public float minimumDifference = 0.0f;
    public InterpolationType interpolation = InterpolationType.BILINEAR;

    public ConfigBackgroundGaussian(float threshold) {
        this.threshold = threshold;
    }

    public ConfigBackgroundGaussian(float threshold, float learnRate) {
        this.threshold = threshold;
        this.learnRate = learnRate;
    }

    public ConfigBackgroundGaussian() {
    }

    public void setTo(ConfigBackgroundGaussian src) {
        super.setTo(src);
        this.learnRate = src.learnRate;
        this.threshold = src.threshold;
        this.initialVariance = src.initialVariance;
        this.minimumDifference = src.minimumDifference;
        this.interpolation = src.interpolation;
    }

    public void checkValidity() {
        if (this.learnRate < 0.0f || this.learnRate > 1.0f) {
            throw new IllegalArgumentException("Learn rate must be 0 <= rate <= 1");
        }
        if (this.threshold <= 0.0f) {
            throw new IllegalArgumentException("threshold must be > 0");
        }
        if (this.initialVariance == 0.0f) {
            throw new IllegalArgumentException("Don't set initialVariance to zero, set it to Float.MIN_VALUE instead");
        }
        if (this.initialVariance < 0.0f) {
            throw new IllegalArgumentException("Variance must be set to a value larger than zero");
        }
        if (this.minimumDifference < 0.0f) {
            throw new IllegalArgumentException("minimumDifference must be >= 0");
        }
    }
}

