/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.line;

import boofcv.abst.feature.detect.extract.ConfigExtract;
import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.abst.feature.detect.line.DetectEdgeLines;
import boofcv.alg.feature.detect.edge.GGradientToEdgeFeatures;
import boofcv.alg.feature.detect.line.HoughParametersFootOfNorm;
import boofcv.alg.feature.detect.line.HoughTransformGradient;
import boofcv.alg.feature.detect.line.ImageLinePruneMerge;
import boofcv.alg.filter.binary.ThresholdImageOps;
import boofcv.factory.feature.detect.extract.FactoryFeatureExtractor;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import georegression.struct.line.LineParametric2D_F32;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.DogArray;

public class DetectLineHoughFootSubimage<D extends ImageGray<D>>
implements DetectEdgeLines<D> {
    int totalHorizontalDivisions;
    int totalVerticalDivisions;
    HoughTransformGradient alg;
    float thresholdEdge;
    D derivX;
    D derivY;
    GrayF32 intensity = new GrayF32(1, 1);
    GrayU8 binary = new GrayU8(1, 1);
    ImageLinePruneMerge post = new ImageLinePruneMerge();
    int maxLines;
    List<LineParametric2D_F32> foundLines;

    public DetectLineHoughFootSubimage(int localMaxRadius, int minCounts, int minDistanceFromOrigin, float thresholdEdge, int totalHorizontalDivisions, int totalVerticalDivisions, int maxLines, Class<D> derivType) {
        this.thresholdEdge = thresholdEdge;
        this.totalHorizontalDivisions = totalHorizontalDivisions;
        this.totalVerticalDivisions = totalVerticalDivisions;
        this.maxLines = maxLines;
        NonMaxSuppression extractor = FactoryFeatureExtractor.nonmaxCandidate(new ConfigExtract(localMaxRadius, minCounts, 0, false));
        this.alg = new HoughTransformGradient<D>(extractor, new HoughParametersFootOfNorm(minDistanceFromOrigin), derivType);
    }

    @Override
    public void detect(D derivX, D derivY) {
        this.derivX = derivX;
        this.derivY = derivY;
        this.foundLines = null;
        this.intensity.reshape(((ImageGray)derivX).width, ((ImageGray)derivX).height);
        this.binary.reshape(((ImageGray)derivX).width, ((ImageGray)derivX).height);
        GGradientToEdgeFeatures.intensityAbs(derivX, derivY, this.intensity);
        ThresholdImageOps.threshold((GrayF32)this.intensity, (GrayU8)this.binary, (float)this.thresholdEdge, (boolean)false);
        ArrayList<LineParametric2D_F32> ret = new ArrayList<LineParametric2D_F32>();
        this.post.reset();
        for (int i = 0; i < this.totalVerticalDivisions; ++i) {
            int y0 = this.intensity.height * i / this.totalVerticalDivisions;
            int y1 = this.intensity.height * (i + 1) / this.totalVerticalDivisions;
            for (int j = 0; j < this.totalHorizontalDivisions; ++j) {
                int x0 = this.intensity.width * j / this.totalVerticalDivisions;
                int x1 = this.intensity.width * (j + 1) / this.totalVerticalDivisions;
                this.processSubimage(x0, y0, x1, y1, ret);
            }
        }
        this.foundLines = this.pruneLines(((ImageGray)derivX).width, ((ImageGray)derivX).height);
        this.derivX = null;
        this.derivY = null;
    }

    @Override
    public List<LineParametric2D_F32> getFoundLines() {
        return this.foundLines;
    }

    private List<LineParametric2D_F32> pruneLines(int width, int height) {
        this.post.pruneSimilar(0.12566371f, 10.0f, width, height);
        this.post.pruneNBest(this.maxLines);
        return this.post.createList(null);
    }

    private void processSubimage(int x0, int y0, int x1, int y1, List<LineParametric2D_F32> found) {
        ImageGray derivX = (ImageGray)this.derivX.subimage(x0, y0, x1, y1);
        ImageGray derivY = (ImageGray)this.derivY.subimage(x0, y0, x1, y1);
        GrayU8 binary = (GrayU8)this.binary.subimage(x0, y0, x1, y1);
        this.alg.transform(derivX, derivY, binary);
        DogArray<LineParametric2D_F32> lines = this.alg.getLinesAll();
        float[] intensity = this.alg.getFoundIntensity();
        for (int i = 0; i < lines.size; ++i) {
            LineParametric2D_F32 l = ((LineParametric2D_F32)lines.get(i)).copy();
            l.p.x += (float)x0;
            l.p.y += (float)y0;
            found.add(l);
            this.post.add(l, intensity[i]);
        }
    }

    public HoughTransformGradient getTransform() {
        return this.alg;
    }

    public GrayF32 getEdgeIntensity() {
        return this.intensity;
    }

    public GrayU8 getBinary() {
        return this.binary;
    }
}

