/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.moving;

import boofcv.alg.background.moving.BackgroundMovingGaussian;
import boofcv.alg.interpolate.InterpolatePixelMB;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.core.image.FactoryGImageMultiBand;
import boofcv.core.image.GImageMultiBand;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.border.BorderType;
import boofcv.struct.distort.Point2Transform2Model_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import georegression.struct.InvertibleTransform;

public class BackgroundMovingGaussian_PL<T extends ImageGray<T>, Motion extends InvertibleTransform<Motion>>
extends BackgroundMovingGaussian<Planar<T>, Motion> {
    protected InterpolatePixelMB<Planar<T>> interpolateInput;
    protected InterpolatePixelMB<Planar<GrayF32>> interpolationBG;
    protected GImageMultiBand inputWrapper;
    protected float[] pixelBG;
    protected float[] pixelInput;
    Planar<GrayF32> background;

    public BackgroundMovingGaussian_PL(float learnRate, float threshold, Point2Transform2Model_F32<Motion> transform, InterpolationType interpType, ImageType<Planar<T>> imageType) {
        super(learnRate, threshold, transform, imageType);
        int numBands = imageType.getNumBands();
        this.interpolateInput = FactoryInterpolation.createPixelMB((double)0.0, (double)255.0, (InterpolationType)InterpolationType.BILINEAR, (BorderType)BorderType.EXTENDED, imageType);
        this.background = new Planar(GrayF32.class, 1, 1, 2 * numBands);
        this.interpolationBG = FactoryInterpolation.createPixelMB((double)0.0, (double)255.0, (InterpolationType)interpType, (BorderType)BorderType.EXTENDED, (ImageType)this.background.getImageType());
        this.interpolationBG.setImage(this.background);
        this.inputWrapper = FactoryGImageMultiBand.create(imageType);
        this.pixelBG = new float[2 * numBands];
        this.pixelInput = new float[numBands];
    }

    @Override
    public void initialize(int backgroundWidth, int backgroundHeight, Motion homeToWorld) {
        this.background.reshape(backgroundWidth, backgroundHeight);
        for (int i = 0; i < this.background.getNumBands(); i += 2) {
            GImageMiscOps.fill((ImageBase)this.background.getBand(i), (double)0.0);
            GImageMiscOps.fill((ImageBase)this.background.getBand(i + 1), (double)-1.0);
        }
        this.homeToWorld.setTo(homeToWorld);
        this.homeToWorld.invert(this.worldToHome);
        this.backgroundWidth = backgroundWidth;
        this.backgroundHeight = backgroundHeight;
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.background.getNumBands(); i += 2) {
            GImageMiscOps.fill((ImageBase)this.background.getBand(i), (double)0.0);
            GImageMiscOps.fill((ImageBase)this.background.getBand(i + 1), (double)-1.0);
        }
    }

    @Override
    protected void updateBackground(int x0, int y0, int x1, int y1, Planar<T> frame) {
        this.transform.setModel((Object)this.worldToCurrent);
        this.interpolateInput.setImage(frame);
        float minusLearn = 1.0f - this.learnRate;
        int numBands = this.background.getNumBands() / 2;
        for (int y = y0; y < y1; ++y) {
            int indexBG = this.background.startIndex + y * this.background.stride + x0;
            int x = x0;
            while (x < x1) {
                this.transform.compute((float)x, (float)y, this.work);
                if (this.work.x >= 0.0f && this.work.x < (float)frame.width && this.work.y >= 0.0f && this.work.y < (float)frame.height) {
                    this.interpolateInput.get(this.work.x, this.work.y, this.pixelInput);
                    for (int band = 0; band < numBands; ++band) {
                        GrayF32 backgroundMean = (GrayF32)this.background.getBand(band * 2);
                        GrayF32 backgroundVar = (GrayF32)this.background.getBand(band * 2 + 1);
                        float inputValue = this.pixelInput[band];
                        float meanBG = backgroundMean.data[indexBG];
                        float varianceBG = backgroundVar.data[indexBG];
                        if (varianceBG < 0.0f) {
                            backgroundMean.data[indexBG] = inputValue;
                            backgroundVar.data[indexBG] = this.initialVariance;
                            continue;
                        }
                        float diff = meanBG - inputValue;
                        backgroundMean.data[indexBG] = minusLearn * meanBG + this.learnRate * inputValue;
                        backgroundVar.data[indexBG] = minusLearn * varianceBG + this.learnRate * diff * diff;
                    }
                }
                ++x;
                ++indexBG;
            }
        }
    }

    @Override
    protected void _segment(Motion currentToWorld, Planar<T> frame, GrayU8 segmented) {
        this.transform.setModel(currentToWorld);
        this.inputWrapper.wrap(frame);
        int numBands = this.background.getNumBands() / 2;
        float adjustedMinimumDifference = this.minimumDifference * (float)numBands;
        for (int y = 0; y < frame.height; ++y) {
            int indexFrame = frame.startIndex + y * frame.stride;
            int indexSegmented = segmented.startIndex + y * segmented.stride;
            int x = 0;
            while (x < frame.width) {
                block11: {
                    this.transform.compute((float)x, (float)y, this.work);
                    if (this.work.x >= 0.0f && this.work.x < (float)this.background.width && this.work.y >= 0.0f && this.work.y < (float)this.background.height) {
                        this.interpolationBG.get(this.work.x, this.work.y, this.pixelBG);
                        this.inputWrapper.getF(indexFrame, this.pixelInput);
                        float mahalanobis = 0.0f;
                        for (int band = 0; band < numBands; ++band) {
                            float meanBG = this.pixelBG[band * 2];
                            float varBG = this.pixelBG[band * 2 + 1];
                            if (varBG < 0.0f) {
                                segmented.data[indexSegmented] = this.unknownValue;
                                break block11;
                            }
                            float diff = meanBG - this.pixelInput[band];
                            mahalanobis += diff * diff / varBG;
                        }
                        if (mahalanobis <= this.threshold) {
                            segmented.data[indexSegmented] = 0;
                        } else if (this.minimumDifference > 0.0f) {
                            float sumAbsDiff = 0.0f;
                            for (int band = 0; band < numBands; ++band) {
                                sumAbsDiff += Math.abs(this.pixelBG[band * 2] - this.pixelInput[band]);
                            }
                            segmented.data[indexSegmented] = sumAbsDiff >= adjustedMinimumDifference ? (byte)1 : 0;
                        } else {
                            segmented.data[indexSegmented] = 1;
                        }
                    } else {
                        segmented.data[indexSegmented] = this.unknownValue;
                    }
                }
                ++x;
                ++indexFrame;
                ++indexSegmented;
            }
        }
    }
}

