/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.associate;

import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.MatchScoreType;
import org.ddogleg.struct.DogArray_F64;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastArray;

public class AssociateUniqueByScoreAlg {
    private MatchScoreType type;
    private boolean checkSource;
    private boolean checkDestination;
    private DogArray_I32 solutions = new DogArray_I32();
    private DogArray_F64 scores = new DogArray_F64();
    private final FastArray<AssociatedIndex> firstPass = new FastArray(AssociatedIndex.class);
    private final FastArray<AssociatedIndex> pruned = new FastArray(AssociatedIndex.class);

    public AssociateUniqueByScoreAlg(MatchScoreType type, boolean checkSource, boolean checkDestination) {
        this.type = type;
        this.checkSource = checkSource;
        this.checkDestination = checkDestination;
    }

    public void process(FastAccess<AssociatedIndex> matches, int numSource, int numDestination) {
        if (this.checkSource) {
            if (this.checkDestination) {
                this.processSource(matches, numSource, this.firstPass);
                this.processDestination((FastAccess<AssociatedIndex>)this.firstPass, numDestination, this.pruned);
            } else {
                this.processSource(matches, numSource, this.pruned);
            }
        } else if (this.checkDestination) {
            this.processDestination(matches, numDestination, this.pruned);
        } else {
            this.pruned.reset();
            this.pruned.addAll(matches.toList());
        }
    }

    private void processSource(FastAccess<AssociatedIndex> matches, int numSource, FastArray<AssociatedIndex> output) {
        int i;
        this.scores.resize(numSource);
        this.solutions.resize(numSource);
        for (i = 0; i < numSource; ++i) {
            this.solutions.data[i] = -1;
        }
        for (i = 0; i < matches.size(); ++i) {
            AssociatedIndex a = (AssociatedIndex)matches.get(i);
            int found = this.solutions.data[a.src];
            if (found != -1) {
                if (found == -2) {
                    double bestScore = this.scores.data[a.src];
                    int result = this.type.compareTo(bestScore, a.fitScore);
                    if (result >= 0) continue;
                    this.solutions.data[a.src] = i;
                    this.scores.data[a.src] = a.fitScore;
                    continue;
                }
                AssociatedIndex currentBest = (AssociatedIndex)matches.get(found);
                int result = this.type.compareTo(currentBest.fitScore, a.fitScore);
                if (result < 0) {
                    this.solutions.data[a.src] = i;
                    this.scores.data[a.src] = a.fitScore;
                    continue;
                }
                if (result != 0) continue;
                this.solutions.data[a.src] = -2;
                continue;
            }
            this.solutions.data[a.src] = i;
            this.scores.data[a.src] = a.fitScore;
        }
        output.reset();
        for (i = 0; i < numSource; ++i) {
            int index = this.solutions.data[i];
            if (index < 0) continue;
            output.add((Object)((AssociatedIndex)matches.get(index)));
        }
    }

    private void processDestination(FastAccess<AssociatedIndex> matches, int numDestination, FastArray<AssociatedIndex> output) {
        int i;
        this.scores.resize(numDestination);
        this.solutions.resize(numDestination);
        for (i = 0; i < numDestination; ++i) {
            this.solutions.data[i] = -1;
        }
        for (i = 0; i < matches.size(); ++i) {
            AssociatedIndex a = (AssociatedIndex)matches.get(i);
            int found = this.solutions.data[a.dst];
            if (found != -1) {
                if (found == -2) {
                    double bestScore = this.scores.data[a.dst];
                    int result = this.type.compareTo(bestScore, a.fitScore);
                    if (result >= 0) continue;
                    this.solutions.data[a.dst] = i;
                    this.scores.data[a.dst] = a.fitScore;
                    continue;
                }
                AssociatedIndex currentBest = (AssociatedIndex)matches.get(found);
                int result = this.type.compareTo(currentBest.fitScore, a.fitScore);
                if (result < 0) {
                    this.solutions.data[a.dst] = i;
                    this.scores.data[a.dst] = a.fitScore;
                    continue;
                }
                if (result != 0) continue;
                this.solutions.data[a.dst] = -2;
                continue;
            }
            this.solutions.data[a.dst] = i;
            this.scores.data[a.dst] = i;
        }
        output.reset();
        for (i = 0; i < numDestination; ++i) {
            int index = this.solutions.data[i];
            if (index < 0) continue;
            output.add((Object)((AssociatedIndex)matches.get(index)));
        }
    }

    public FastAccess<AssociatedIndex> getMatches() {
        return this.pruned;
    }

    public boolean checkSource() {
        return this.checkSource;
    }

    public boolean checkDestination() {
        return this.checkDestination;
    }
}

