/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.selector;

import boofcv.alg.feature.detect.selector.FeatureSelectLimitIntensity;
import boofcv.alg.feature.detect.selector.SampleIntensity;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.ConfigGridUniform;
import boofcv.struct.ImageGrid;
import boofcv.struct.image.GrayF32;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.sorting.QuickSort_F32;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F32;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastArray;
import org.jetbrains.annotations.Nullable;

public class FeatureSelectUniformBest<Point>
implements FeatureSelectLimitIntensity<Point> {
    public ConfigGridUniform configUniform = new ConfigGridUniform();
    final ImageGrid<Info<Point>> grid = new ImageGrid(Info::new, Info::reset);
    SampleIntensity<Point> sampler;
    final DogArray_F32 pointIntensity = new DogArray_F32();
    final QuickSort_F32 sorter = new QuickSort_F32();
    final DogArray_I32 indexes = new DogArray_I32();
    List<Point> workList = new ArrayList<Point>();

    public FeatureSelectUniformBest(SampleIntensity<Point> sampler) {
        this.sampler = sampler;
    }

    public FeatureSelectUniformBest() {
    }

    @Override
    public void select(@Nullable GrayF32 intensity, int width, int height, boolean positive, @Nullable FastAccess<Point> prior, FastAccess<Point> detected, int limit, FastArray<Point> selected) {
        Object p;
        int i;
        BoofMiscOps.checkTrue((limit > 0 ? 1 : 0) != 0);
        selected.reset();
        width = intensity == null ? width : intensity.width;
        int n = height = intensity == null ? height : intensity.height;
        if ((prior == null || prior.size == 0) && detected.size <= limit) {
            selected.addAll(detected);
            return;
        }
        int targetCellSize = this.configUniform.selectTargetCellSize(limit, width, height);
        this.grid.initialize(targetCellSize, width, height);
        if (prior != null) {
            for (i = 0; i < prior.size; ++i) {
                p = prior.data[i];
                ++this.getGridCell(p).priorCount;
            }
        }
        for (i = 0; i < detected.size; ++i) {
            p = detected.data[i];
            this.getGridCell(p).detected.add(p);
        }
        this.sortCellLists(intensity, positive);
        DogArray cells = this.grid.cells;
        selected.resize(limit);
        selected.reset();
        while (selected.size < limit) {
            boolean change = false;
            for (int cellidx = 0; cellidx < cells.size && selected.size < limit; ++cellidx) {
                Info info = (Info)cells.get(cellidx);
                if (info.priorCount > 0) {
                    --info.priorCount;
                    change = true;
                    continue;
                }
                if (info.detected.isEmpty()) continue;
                selected.add(info.detected.remove(info.detected.size() - 1));
                change = true;
            }
            if (change) continue;
            break;
        }
    }

    @Override
    public void setSampler(SampleIntensity<Point> sampler) {
        this.sampler = sampler;
    }

    private void sortCellLists(GrayF32 intensity, boolean positive) {
        DogArray cells = this.grid.cells;
        for (int cellidx = 0; cellidx < cells.size; ++cellidx) {
            Object p;
            int pointIdx;
            List cellPoints = ((Info)cells.get((int)cellidx)).detected;
            if (cellPoints.isEmpty()) continue;
            int N = cellPoints.size();
            this.pointIntensity.resize(N);
            this.indexes.resize(N);
            if (positive) {
                for (pointIdx = 0; pointIdx < N; ++pointIdx) {
                    p = cellPoints.get(pointIdx);
                    this.pointIntensity.data[pointIdx] = this.sampler.sample(intensity, pointIdx, p);
                }
            } else {
                for (pointIdx = 0; pointIdx < N; ++pointIdx) {
                    p = cellPoints.get(pointIdx);
                    this.pointIntensity.data[pointIdx] = -this.sampler.sample(intensity, pointIdx, p);
                }
            }
            this.sorter.sort(this.pointIntensity.data, 0, N, this.indexes.data);
            this.workList.clear();
            for (int i = 0; i < N; ++i) {
                this.workList.add(cellPoints.get(this.indexes.data[i]));
            }
            List tmp = ((Info[])cells.data)[cellidx].detected;
            ((Info[])cells.data)[cellidx].detected = this.workList;
            this.workList = tmp;
        }
    }

    protected Info<Point> getGridCell(Point p) {
        return (Info)this.grid.getCellAtPixel(this.sampler.getX(p), this.sampler.getY(p));
    }

    public static class Info<Point> {
        int priorCount = 0;
        List<Point> detected = new ArrayList<Point>();

        public void reset() {
            this.priorCount = 0;
            this.detected.clear();
        }
    }
}

