/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.segmentation.fh04;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.segmentation.fh04.FhEdgeWeights;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import org.ddogleg.sorting.ApproximateSort_F32;
import org.ddogleg.sorting.QuickSortObj_F32;
import org.ddogleg.sorting.SortableParameter_F32;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F32;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastArray;

public class SegmentFelzenszwalbHuttenlocher04<T extends ImageBase<T>> {
    private final float K;
    private final int minimumSize;
    protected GrayS32 graph;
    private final FhEdgeWeights<T> computeWeights;
    private final QuickSortObj_F32 sorter = new QuickSortObj_F32();
    private ApproximateSort_F32 sorterApprox = null;
    protected DogArray<Edge> edges = new DogArray(Edge::new);
    protected FastArray<Edge> edgesNotMatched = new FastArray(Edge.class);
    protected DogArray_I32 regionSize = new DogArray_I32();
    protected DogArray_F32 threshold = new DogArray_F32();
    private final DogArray_I32 outputRegionId = new DogArray_I32();
    private final DogArray_I32 outputRegionSizes = new DogArray_I32();

    public SegmentFelzenszwalbHuttenlocher04(float k, int minimumSize, FhEdgeWeights<T> computeWeights) {
        this.K = k;
        this.minimumSize = minimumSize;
        this.computeWeights = computeWeights;
    }

    public void configureApproximateSort(int numBins) {
        this.sorterApprox = new ApproximateSort_F32(numBins);
    }

    public void process(T input, GrayS32 output) {
        if (output.isSubimage()) {
            throw new IllegalArgumentException("Output can't be a sub-image");
        }
        InputSanityCheck.checkSameShape(input, (ImageBase)output);
        this.initialize(input, output);
        this.computeWeights.process(input, this.edges);
        this.mergeRegions();
        this.mergeSmallRegions();
        this.computeOutput();
    }

    protected void initialize(T input, GrayS32 output) {
        this.graph = output;
        int N = ((ImageBase)input).width * ((ImageBase)input).height;
        this.regionSize.resize(N);
        this.threshold.resize(N);
        for (int i = 0; i < N; ++i) {
            this.regionSize.data[i] = 1;
            this.threshold.data[i] = this.K;
            this.graph.data[i] = i;
        }
        this.edges.reset();
        this.edgesNotMatched.reset();
    }

    protected void mergeRegions() {
        if (this.sorterApprox != null) {
            this.sorterApprox.computeRange((SortableParameter_F32[])this.edges.data, 0, this.edges.size);
            this.sorterApprox.sortObject((SortableParameter_F32[])this.edges.data, 0, this.edges.size);
        } else {
            this.sorter.sort((SortableParameter_F32[])this.edges.data, this.edges.size);
        }
        for (int i = 0; i < this.edges.size(); ++i) {
            int rootB;
            Edge e = (Edge)((Object)this.edges.get(i));
            int rootA = this.find(e.indexA);
            if (rootA == (rootB = this.find(e.indexB))) continue;
            float threshA = this.threshold.get(rootA);
            float threshB = this.threshold.get(rootB);
            if (e.weight() <= threshA && e.weight() <= threshB) {
                int sizeA = this.regionSize.get(rootA);
                int sizeB = this.regionSize.get(rootB);
                this.threshold.data[rootA] = e.weight() + this.K / (float)(sizeA + sizeB);
                this.graph.data[e.indexB] = rootA;
                this.graph.data[rootB] = rootA;
                this.regionSize.data[rootA] = sizeA + sizeB;
                continue;
            }
            this.edgesNotMatched.add((Object)e);
        }
    }

    protected void mergeSmallRegions() {
        for (int i = 0; i < this.edgesNotMatched.size(); ++i) {
            int rootB;
            Edge e = (Edge)((Object)this.edgesNotMatched.get(i));
            int rootA = this.find(e.indexA);
            if (rootA == (rootB = this.find(e.indexB))) continue;
            int sizeA = this.regionSize.get(rootA);
            int sizeB = this.regionSize.get(rootB);
            if (sizeA >= this.minimumSize && sizeB >= this.minimumSize) continue;
            this.graph.data[e.indexB] = rootA;
            this.graph.data[rootB] = rootA;
            this.regionSize.data[rootA] = sizeA + sizeB;
        }
    }

    protected int find(int child) {
        int root = this.graph.data[child];
        if (root == this.graph.data[root]) {
            return root;
        }
        int inputChild = child;
        while (root != child) {
            child = root;
            root = this.graph.data[child];
        }
        this.graph.data[inputChild] = root;
        return root;
    }

    protected void computeOutput() {
        this.outputRegionId.reset();
        this.outputRegionSizes.reset();
        for (int y = 0; y < this.graph.height; ++y) {
            int indexGraph = this.graph.startIndex + y * this.graph.stride;
            int x = 0;
            while (x < this.graph.width) {
                int parent = this.graph.data[indexGraph];
                if (parent == indexGraph) {
                    this.outputRegionId.add(indexGraph);
                    this.outputRegionSizes.add(this.regionSize.get(indexGraph));
                } else {
                    int child = indexGraph;
                    while (parent != child) {
                        child = parent;
                        parent = this.graph.data[child];
                    }
                    this.graph.data[indexGraph] = parent;
                }
                ++x;
                ++indexGraph;
            }
        }
    }

    public DogArray_I32 getRegionId() {
        return this.outputRegionId;
    }

    public DogArray_I32 getRegionSizes() {
        return this.outputRegionSizes;
    }

    public ImageType<T> getInputType() {
        return this.computeWeights.getInputType();
    }

    public static class Edge
    extends SortableParameter_F32 {
        public int indexA;
        public int indexB;

        public Edge(int indexA, int indexB) {
            this.indexA = indexA;
            this.indexB = indexB;
        }

        public Edge() {
        }

        public final float weight() {
            return this.sortValue;
        }
    }
}

