/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.describe;

import boofcv.alg.descriptor.UtilFeature;
import boofcv.alg.filter.kernel.KernelMath;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.feature.TupleDesc_F64;
import georegression.metric.UtilAngle;

public class DescribeSiftCommon {
    protected int widthSubregion;
    protected int widthGrid;
    protected int numHistogramBins;
    protected double histogramBinWidth;
    protected double maxDescriptorElementValue;
    protected float[] gaussianWeight;

    public DescribeSiftCommon(int widthSubregion, int widthGrid, int numHistogramBins, double weightingSigmaFraction, double maxDescriptorElementValue) {
        this.widthSubregion = widthSubregion;
        this.widthGrid = widthGrid;
        this.numHistogramBins = numHistogramBins;
        this.maxDescriptorElementValue = maxDescriptorElementValue;
        this.histogramBinWidth = Math.PI * 2 / (double)numHistogramBins;
        int descriptorWindow = widthSubregion * widthGrid;
        double weightSigma = (double)descriptorWindow * weightingSigmaFraction;
        this.gaussianWeight = DescribeSiftCommon.createGaussianWeightKernel(weightSigma, descriptorWindow / 2);
    }

    public static void normalizeDescriptor(TupleDesc_F64 descriptor, double maxDescriptorElementValue) {
        UtilFeature.normalizeL2(descriptor);
        for (int i = 0; i < descriptor.size(); ++i) {
            double value = descriptor.data[i];
            if (!(value > maxDescriptorElementValue)) continue;
            descriptor.data[i] = maxDescriptorElementValue;
        }
        UtilFeature.normalizeL2(descriptor);
    }

    protected static float[] createGaussianWeightKernel(double sigma, int radius) {
        Kernel2D_F32 ker = FactoryKernelGaussian.gaussian2D_F32((double)sigma, (int)radius, (boolean)false, (boolean)false);
        float maxValue = KernelMath.maxAbs((float[])ker.data, (int)(4 * radius * radius));
        KernelMath.divide((Kernel2D_F32)ker, (float)maxValue);
        return ker.data;
    }

    protected void trilinearInterpolation(float weight, float sampleX, float sampleY, double angle, TupleDesc_F64 descriptor) {
        for (int i = 0; i < this.widthGrid; ++i) {
            double weightGridY = 1.0 - (double)Math.abs(sampleY - (float)i);
            if (weightGridY <= 0.0) continue;
            for (int j = 0; j < this.widthGrid; ++j) {
                double weightGridX = 1.0 - (double)Math.abs(sampleX - (float)j);
                if (weightGridX <= 0.0) continue;
                for (int k = 0; k < this.numHistogramBins; ++k) {
                    int descriptorIndex;
                    double angleBin = (double)k * this.histogramBinWidth;
                    double weightHistogram = 1.0 - UtilAngle.dist((double)angle, (double)angleBin) / this.histogramBinWidth;
                    if (weightHistogram <= 0.0) continue;
                    int n = descriptorIndex = (i * this.widthGrid + j) * this.numHistogramBins + k;
                    descriptor.data[n] = descriptor.data[n] + (double)weight * weightGridX * weightGridY * weightHistogram;
                }
            }
        }
    }

    public int getDescriptorLength() {
        return this.widthGrid * this.widthGrid * this.numHistogramBins;
    }

    public int getCanonicalRadius() {
        return this.widthGrid * this.widthSubregion / 2;
    }
}

