/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.tracker;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.abst.tracker.PointTrack;
import boofcv.abst.tracker.PointTracker;
import boofcv.abst.tracker.PointTrackerUtils;
import boofcv.alg.tracker.hybrid.HybridTrack;
import boofcv.alg.tracker.hybrid.HybridTrackerScalePoint;
import boofcv.alg.transform.pyramid.PyramidOps;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.factory.transform.pyramid.FactoryPyramid;
import boofcv.struct.ConfigLength;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.pyramid.ConfigDiscreteLevels;
import boofcv.struct.pyramid.PyramidDiscrete;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.jetbrains.annotations.Nullable;

public class PointTrackerHybrid<I extends ImageGray<I>, D extends ImageGray<D>, Desc extends TupleDesc<Desc>>
implements PointTracker<I> {
    HybridTrackerScalePoint<I, D, Desc> tracker;
    public final ConfigLength thresholdRespawn = ConfigLength.relative((double)0.4, (double)50.0);
    private int countAfterSpawn;
    I image;
    PyramidDiscrete<I> pyramid;
    D[] derivX;
    D[] derivY;
    ImageType<D> derivType;
    ImageGradient<I, D> gradient;
    ImageType<I> inputType;
    boolean detectCalled;

    public PointTrackerHybrid(HybridTrackerScalePoint<I, D, Desc> tracker, ConfigDiscreteLevels configLevels, Class<I> imageType, Class<D> derivType) {
        this.tracker = tracker;
        this.derivType = ImageType.single(derivType);
        this.inputType = ImageType.single(imageType);
        this.pyramid = FactoryPyramid.discreteGaussian((ConfigDiscreteLevels)configLevels, (double)-1.0, (int)2, (boolean)true, (ImageType)ImageType.single(imageType));
        this.gradient = FactoryDerivative.sobel(imageType, derivType);
        this.reset();
    }

    @Override
    public void process(I image) {
        this.image = image;
        this.detectCalled = false;
        this.pyramid.process(image);
        if (this.derivX == null) {
            this.derivX = PyramidOps.declareOutput(this.pyramid, this.derivType);
            this.derivY = PyramidOps.declareOutput(this.pyramid, this.derivType);
        }
        PyramidOps.gradient(this.pyramid, this.gradient, this.derivX, this.derivY);
        this.tracker.updateTracks((PyramidDiscrete)this.pyramid, (ImageGray[])this.derivX, (ImageGray[])this.derivY);
        if (this.tracker.getTracksActive().size < this.thresholdRespawn.computeI((double)this.countAfterSpawn)) {
            this.detectCalled = true;
            this.tracker.associateInactiveTracks(image);
            this.countAfterSpawn = this.tracker.getTracksActive().size;
        }
        this.tracker.pruneActiveTracksWhichAreTooClose();
        this.tracker.dropExcessiveInactiveTracks();
    }

    @Override
    public void dropTracks(PointTracker.Dropper dropper) {
        DogArray<HybridTrack<Desc>> all = this.tracker.getTracksAll();
        for (int i = all.size - 1; i >= 0; --i) {
            if (!dropper.shouldDropTrack((PointTrack)all.get(i))) continue;
            this.tracker.dropTrackByAllIndex(i);
            --this.countAfterSpawn;
        }
    }

    @Override
    public void spawnTracks() {
        if (!this.detectCalled) {
            this.tracker.associateInactiveTracks(this.image);
        }
        this.tracker.spawnNewTracks();
        this.countAfterSpawn = this.tracker.getTracksActive().size;
    }

    @Override
    public ImageType<I> getImageType() {
        return this.inputType;
    }

    @Override
    public void reset() {
        this.countAfterSpawn = 0;
        this.tracker.reset();
    }

    @Override
    public long getFrameID() {
        return this.tracker.getFrameID();
    }

    @Override
    public int getTotalActive() {
        return this.tracker.getTracksActive().size();
    }

    @Override
    public int getTotalInactive() {
        return this.tracker.getTracksInactive().size();
    }

    @Override
    public void dropAllTracks() {
        this.tracker.dropAllTracks();
    }

    @Override
    public int getMaxSpawn() {
        return 0;
    }

    @Override
    public boolean dropTrack(PointTrack track) {
        if (this.tracker.dropTrack((HybridTrack)track)) {
            --this.countAfterSpawn;
            return true;
        }
        return false;
    }

    @Override
    public List<PointTrack> getAllTracks(@Nullable List<PointTrack> list) {
        return PointTrackerUtils.addAllTracksInList(this.tracker.getTracksAll().toList(), list);
    }

    @Override
    public List<PointTrack> getActiveTracks(@Nullable List<PointTrack> list) {
        return PointTrackerUtils.addAllTracksInList(this.tracker.getTracksActive().toList(), list);
    }

    @Override
    public List<PointTrack> getInactiveTracks(@Nullable List<PointTrack> list) {
        return PointTrackerUtils.addAllTracksInList(this.tracker.getTracksInactive().toList(), list);
    }

    @Override
    public List<PointTrack> getDroppedTracks(@Nullable List<PointTrack> list) {
        return PointTrackerUtils.addAllTracksInList(this.tracker.getTracksDropped(), list);
    }

    @Override
    public List<PointTrack> getNewTracks(@Nullable List<PointTrack> list) {
        return PointTrackerUtils.addAllTracksInList(this.tracker.getTracksSpawned(), list);
    }
}

