/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.shapes.ellipse;

import boofcv.alg.filter.binary.ContourPacked;
import boofcv.alg.shapes.ellipse.BinaryEllipseDetectorPixel;
import boofcv.alg.shapes.ellipse.EdgeIntensityEllipse;
import boofcv.alg.shapes.ellipse.SnapToEllipseEdge;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import georegression.struct.curve.EllipseRotated_F64;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_I32;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.jetbrains.annotations.Nullable;

public class BinaryEllipseDetector<T extends ImageGray<T>> {
    BinaryEllipseDetectorPixel ellipseDetector;
    @Nullable
    SnapToEllipseEdge<T> ellipseRefiner;
    EdgeIntensityEllipse<T> intensityCheck;
    DogArray<EllipseInfo> results = new DogArray(EllipseInfo::new);
    Class<T> inputType;
    boolean verbose = false;
    boolean autoRefine = true;

    public BinaryEllipseDetector(BinaryEllipseDetectorPixel ellipseDetector, @Nullable SnapToEllipseEdge<T> ellipseRefiner, EdgeIntensityEllipse<T> intensityCheck, Class<T> inputType) {
        this.ellipseDetector = ellipseDetector;
        this.ellipseRefiner = ellipseRefiner;
        this.intensityCheck = intensityCheck;
        this.inputType = inputType;
    }

    public void setLensDistortion(@Nullable PixelTransform<Point2D_F32> distToUndist, @Nullable PixelTransform<Point2D_F32> undistToDist) {
        this.ellipseDetector.setLensDistortion(distToUndist);
        if (this.ellipseRefiner != null) {
            this.ellipseRefiner.setTransform(undistToDist);
        }
        this.intensityCheck.setTransform(undistToDist);
    }

    public void process(T gray, GrayU8 binary) {
        this.results.reset();
        this.ellipseDetector.process(binary);
        if (this.ellipseRefiner != null) {
            this.ellipseRefiner.setImage(gray);
        }
        this.intensityCheck.setImage(gray);
        List<BinaryEllipseDetectorPixel.Found> found = this.ellipseDetector.getFound();
        for (BinaryEllipseDetectorPixel.Found f : found) {
            if (!this.intensityCheck.process(f.ellipse)) {
                if (!this.verbose) continue;
                System.out.println("Rejecting ellipse. Initial fit didn't have intense enough edge");
                continue;
            }
            EllipseInfo r = (EllipseInfo)this.results.grow();
            r.contour = f.contour;
            if (this.ellipseRefiner != null) {
                if (!this.ellipseRefiner.process(f.ellipse, r.ellipse)) {
                    if (this.verbose) {
                        System.out.println("Rejecting ellipse. Refined fit didn't have an intense enough edge");
                    }
                    this.results.removeTail();
                    continue;
                }
                if (!this.intensityCheck.process(f.ellipse)) {
                    if (!this.verbose) continue;
                    System.out.println("Rejecting ellipse. Refined fit didn't have an intense enough edge");
                    continue;
                }
            } else {
                r.ellipse.setTo(f.ellipse);
            }
            r.averageInside = this.intensityCheck.averageInside;
            r.averageOutside = this.intensityCheck.averageOutside;
        }
    }

    public boolean refine(EllipseRotated_F64 ellipse) {
        if (this.autoRefine) {
            throw new IllegalArgumentException("Autorefine is true, no need to refine again");
        }
        if (this.ellipseRefiner == null) {
            throw new IllegalArgumentException("Refiner has not been passed in");
        }
        return this.ellipseRefiner.process(ellipse, ellipse);
    }

    public BinaryEllipseDetectorPixel getEllipseDetector() {
        return this.ellipseDetector;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isAutoRefine() {
        return this.autoRefine;
    }

    public void setAutoRefine(boolean autoRefine) {
        this.autoRefine = autoRefine;
    }

    public Class<T> getInputType() {
        return this.inputType;
    }

    public List<ContourPacked> getAllContours() {
        return this.ellipseDetector.getContours();
    }

    public DogArray<EllipseInfo> getFound() {
        return this.results;
    }

    public List<EllipseRotated_F64> getFoundEllipses(@Nullable List<EllipseRotated_F64> storage) {
        if (storage == null) {
            storage = new ArrayList<EllipseRotated_F64>();
        }
        for (int i = 0; i < this.results.size; ++i) {
            storage.add(((EllipseInfo)this.results.get((int)i)).ellipse);
        }
        return storage;
    }

    public static class EllipseInfo {
        public EllipseRotated_F64 ellipse = new EllipseRotated_F64();
        public List<Point2D_I32> contour;
        public double averageInside;
        public double averageOutside;
    }
}

