/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.background;

import boofcv.alg.background.moving.BackgroundMovingBasic;
import boofcv.alg.background.moving.BackgroundMovingBasic_IL;
import boofcv.alg.background.moving.BackgroundMovingBasic_IL_MT;
import boofcv.alg.background.moving.BackgroundMovingBasic_PL;
import boofcv.alg.background.moving.BackgroundMovingBasic_PL_MT;
import boofcv.alg.background.moving.BackgroundMovingBasic_SB;
import boofcv.alg.background.moving.BackgroundMovingBasic_SB_MT;
import boofcv.alg.background.moving.BackgroundMovingGaussian;
import boofcv.alg.background.moving.BackgroundMovingGaussian_IL;
import boofcv.alg.background.moving.BackgroundMovingGaussian_IL_MT;
import boofcv.alg.background.moving.BackgroundMovingGaussian_PL;
import boofcv.alg.background.moving.BackgroundMovingGaussian_PL_MT;
import boofcv.alg.background.moving.BackgroundMovingGaussian_SB;
import boofcv.alg.background.moving.BackgroundMovingGaussian_SB_MT;
import boofcv.alg.background.moving.BackgroundMovingGmm;
import boofcv.alg.background.moving.BackgroundMovingGmm_MB;
import boofcv.alg.background.moving.BackgroundMovingGmm_MB_MT;
import boofcv.alg.background.moving.BackgroundMovingGmm_SB;
import boofcv.alg.background.moving.BackgroundMovingGmm_SB_MT;
import boofcv.alg.background.stationary.BackgroundStationaryBasic;
import boofcv.alg.background.stationary.BackgroundStationaryBasic_IL;
import boofcv.alg.background.stationary.BackgroundStationaryBasic_IL_MT;
import boofcv.alg.background.stationary.BackgroundStationaryBasic_PL;
import boofcv.alg.background.stationary.BackgroundStationaryBasic_PL_MT;
import boofcv.alg.background.stationary.BackgroundStationaryBasic_SB;
import boofcv.alg.background.stationary.BackgroundStationaryGaussian;
import boofcv.alg.background.stationary.BackgroundStationaryGaussian_IL;
import boofcv.alg.background.stationary.BackgroundStationaryGaussian_IL_MT;
import boofcv.alg.background.stationary.BackgroundStationaryGaussian_PL;
import boofcv.alg.background.stationary.BackgroundStationaryGaussian_PL_MT;
import boofcv.alg.background.stationary.BackgroundStationaryGaussian_SB;
import boofcv.alg.background.stationary.BackgroundStationaryGmm;
import boofcv.alg.background.stationary.BackgroundStationaryGmm_MB;
import boofcv.alg.background.stationary.BackgroundStationaryGmm_MB_MT;
import boofcv.alg.background.stationary.BackgroundStationaryGmm_SB;
import boofcv.alg.background.stationary.BackgroundStationaryGmm_SB_MT;
import boofcv.concurrency.BoofConcurrency;
import boofcv.factory.background.ConfigBackgroundBasic;
import boofcv.factory.background.ConfigBackgroundGaussian;
import boofcv.factory.background.ConfigBackgroundGmm;
import boofcv.struct.distort.Point2Transform2Model_F32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.struct.InvertibleTransform;
import org.jetbrains.annotations.Nullable;

public class FactoryBackgroundModel {
    public static <T extends ImageBase<T>> BackgroundStationaryBasic<T> stationaryBasic(ConfigBackgroundBasic config, ImageType<T> imageType) {
        BackgroundStationaryBasic backgroundStationaryBasic;
        config.checkValidity();
        if (BoofConcurrency.isUseConcurrent()) {
            BackgroundStationaryBasic backgroundStationaryBasic2;
            switch (imageType.getFamily()) {
                case GRAY: {
                    backgroundStationaryBasic2 = new BackgroundStationaryBasic_SB(config.learnRate, config.threshold, imageType.getImageClass());
                    break;
                }
                case PLANAR: {
                    backgroundStationaryBasic2 = new BackgroundStationaryBasic_PL_MT(config.learnRate, config.threshold, imageType);
                    break;
                }
                case INTERLEAVED: {
                    backgroundStationaryBasic2 = new BackgroundStationaryBasic_IL_MT<T>(config.learnRate, config.threshold, imageType);
                    break;
                }
                default: {
                    throw new IncompatibleClassChangeError();
                }
            }
            return backgroundStationaryBasic2;
        }
        switch (imageType.getFamily()) {
            case GRAY: {
                backgroundStationaryBasic = new BackgroundStationaryBasic_SB(config.learnRate, config.threshold, imageType.getImageClass());
                break;
            }
            case PLANAR: {
                backgroundStationaryBasic = new BackgroundStationaryBasic_PL(config.learnRate, config.threshold, imageType);
                break;
            }
            case INTERLEAVED: {
                backgroundStationaryBasic = new BackgroundStationaryBasic_IL<T>(config.learnRate, config.threshold, imageType);
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        return backgroundStationaryBasic;
    }

    public static <T extends ImageBase<T>, Motion extends InvertibleTransform<Motion>> BackgroundMovingBasic<T, Motion> movingBasic(ConfigBackgroundBasic config, Point2Transform2Model_F32<Motion> transform, ImageType<T> imageType) {
        BackgroundMovingBasic ret;
        config.checkValidity();
        if (BoofConcurrency.isUseConcurrent()) {
            BackgroundMovingBasic backgroundMovingBasic;
            switch (imageType.getFamily()) {
                case GRAY: {
                    backgroundMovingBasic = new BackgroundMovingBasic_SB_MT(config.learnRate, config.threshold, transform, config.interpolation, imageType.getImageClass());
                    break;
                }
                case PLANAR: {
                    backgroundMovingBasic = new BackgroundMovingBasic_PL_MT(config.learnRate, config.threshold, transform, config.interpolation, imageType);
                    break;
                }
                case INTERLEAVED: {
                    backgroundMovingBasic = new BackgroundMovingBasic_IL_MT<T, Motion>(config.learnRate, config.threshold, transform, config.interpolation, imageType);
                    break;
                }
                default: {
                    throw new IncompatibleClassChangeError();
                }
            }
            ret = backgroundMovingBasic;
        } else {
            BackgroundMovingBasic backgroundMovingBasic;
            switch (imageType.getFamily()) {
                case GRAY: {
                    backgroundMovingBasic = new BackgroundMovingBasic_SB(config.learnRate, config.threshold, transform, config.interpolation, imageType.getImageClass());
                    break;
                }
                case PLANAR: {
                    backgroundMovingBasic = new BackgroundMovingBasic_PL(config.learnRate, config.threshold, transform, config.interpolation, imageType);
                    break;
                }
                case INTERLEAVED: {
                    backgroundMovingBasic = new BackgroundMovingBasic_IL<T, Motion>(config.learnRate, config.threshold, transform, config.interpolation, imageType);
                    break;
                }
                default: {
                    throw new IncompatibleClassChangeError();
                }
            }
            ret = backgroundMovingBasic;
        }
        ret.setUnknownValue(config.unknownValue);
        return ret;
    }

    public static <T extends ImageBase<T>> BackgroundStationaryGaussian<T> stationaryGaussian(ConfigBackgroundGaussian config, ImageType<T> imageType) {
        BackgroundStationaryGaussian ret;
        config.checkValidity();
        if (BoofConcurrency.isUseConcurrent()) {
            BackgroundStationaryGaussian backgroundStationaryGaussian;
            switch (imageType.getFamily()) {
                case GRAY: {
                    backgroundStationaryGaussian = new BackgroundStationaryGaussian_SB(config.learnRate, config.threshold, imageType.getImageClass());
                    break;
                }
                case PLANAR: {
                    backgroundStationaryGaussian = new BackgroundStationaryGaussian_PL_MT(config.learnRate, config.threshold, imageType);
                    break;
                }
                case INTERLEAVED: {
                    backgroundStationaryGaussian = new BackgroundStationaryGaussian_IL_MT<T>(config.learnRate, config.threshold, imageType);
                    break;
                }
                default: {
                    throw new IncompatibleClassChangeError();
                }
            }
            ret = backgroundStationaryGaussian;
        } else {
            BackgroundStationaryGaussian backgroundStationaryGaussian;
            switch (imageType.getFamily()) {
                case GRAY: {
                    backgroundStationaryGaussian = new BackgroundStationaryGaussian_SB(config.learnRate, config.threshold, imageType.getImageClass());
                    break;
                }
                case PLANAR: {
                    backgroundStationaryGaussian = new BackgroundStationaryGaussian_PL(config.learnRate, config.threshold, imageType);
                    break;
                }
                case INTERLEAVED: {
                    backgroundStationaryGaussian = new BackgroundStationaryGaussian_IL<T>(config.learnRate, config.threshold, imageType);
                    break;
                }
                default: {
                    throw new IncompatibleClassChangeError();
                }
            }
            ret = backgroundStationaryGaussian;
        }
        ret.setInitialVariance(config.initialVariance);
        ret.setMinimumDifference(config.minimumDifference);
        ret.setUnknownValue(config.unknownValue);
        return ret;
    }

    public static <T extends ImageBase<T>, Motion extends InvertibleTransform<Motion>> BackgroundMovingGaussian<T, Motion> movingGaussian(ConfigBackgroundGaussian config, Point2Transform2Model_F32<Motion> transform, ImageType<T> imageType) {
        BackgroundMovingGaussian ret;
        config.checkValidity();
        if (BoofConcurrency.isUseConcurrent()) {
            BackgroundMovingGaussian backgroundMovingGaussian;
            switch (imageType.getFamily()) {
                case GRAY: {
                    backgroundMovingGaussian = new BackgroundMovingGaussian_SB_MT(config.learnRate, config.threshold, transform, config.interpolation, imageType.getImageClass());
                    break;
                }
                case PLANAR: {
                    backgroundMovingGaussian = new BackgroundMovingGaussian_PL_MT(config.learnRate, config.threshold, transform, config.interpolation, imageType);
                    break;
                }
                case INTERLEAVED: {
                    backgroundMovingGaussian = new BackgroundMovingGaussian_IL_MT<T, Motion>(config.learnRate, config.threshold, transform, config.interpolation, imageType);
                    break;
                }
                default: {
                    throw new IncompatibleClassChangeError();
                }
            }
            ret = backgroundMovingGaussian;
        } else {
            BackgroundMovingGaussian backgroundMovingGaussian;
            switch (imageType.getFamily()) {
                case GRAY: {
                    backgroundMovingGaussian = new BackgroundMovingGaussian_SB(config.learnRate, config.threshold, transform, config.interpolation, imageType.getImageClass());
                    break;
                }
                case PLANAR: {
                    backgroundMovingGaussian = new BackgroundMovingGaussian_PL(config.learnRate, config.threshold, transform, config.interpolation, imageType);
                    break;
                }
                case INTERLEAVED: {
                    backgroundMovingGaussian = new BackgroundMovingGaussian_IL<T, Motion>(config.learnRate, config.threshold, transform, config.interpolation, imageType);
                    break;
                }
                default: {
                    throw new IncompatibleClassChangeError();
                }
            }
            ret = backgroundMovingGaussian;
        }
        ret.setInitialVariance(config.initialVariance);
        ret.setMinimumDifference(config.minimumDifference);
        ret.setUnknownValue(config.unknownValue);
        return ret;
    }

    public static <T extends ImageBase<T>> BackgroundStationaryGmm<T> stationaryGmm(@Nullable ConfigBackgroundGmm config, ImageType<T> imageType) {
        BackgroundStationaryGmm ret;
        if (config == null) {
            config = new ConfigBackgroundGmm();
        } else {
            config.checkValidity();
        }
        if (BoofConcurrency.isUseConcurrent()) {
            BackgroundStationaryGmm backgroundStationaryGmm;
            switch (imageType.getFamily()) {
                case GRAY: {
                    backgroundStationaryGmm = new BackgroundStationaryGmm_SB_MT<T>(config.learningPeriod, config.decayCoefient, config.numberOfGaussian, imageType);
                    break;
                }
                case PLANAR: 
                case INTERLEAVED: {
                    backgroundStationaryGmm = new BackgroundStationaryGmm_MB_MT<T>(config.learningPeriod, config.decayCoefient, config.numberOfGaussian, imageType);
                    break;
                }
                default: {
                    throw new IncompatibleClassChangeError();
                }
            }
            ret = backgroundStationaryGmm;
        } else {
            BackgroundStationaryGmm backgroundStationaryGmm;
            switch (imageType.getFamily()) {
                case GRAY: {
                    backgroundStationaryGmm = new BackgroundStationaryGmm_SB<T>(config.learningPeriod, config.decayCoefient, config.numberOfGaussian, imageType);
                    break;
                }
                case PLANAR: 
                case INTERLEAVED: {
                    backgroundStationaryGmm = new BackgroundStationaryGmm_MB<T>(config.learningPeriod, config.decayCoefient, config.numberOfGaussian, imageType);
                    break;
                }
                default: {
                    throw new IncompatibleClassChangeError();
                }
            }
            ret = backgroundStationaryGmm;
        }
        ret.setInitialVariance(config.initialVariance);
        ret.setMaxDistance(config.maxDistance);
        ret.setSignificantWeight(config.significantWeight);
        ret.setUnknownValue(config.unknownValue);
        return ret;
    }

    public static <T extends ImageBase<T>, Motion extends InvertibleTransform<Motion>> BackgroundMovingGmm<T, Motion> movingGmm(@Nullable ConfigBackgroundGmm config, Point2Transform2Model_F32<Motion> transform, ImageType<T> imageType) {
        BackgroundMovingGmm ret;
        if (config == null) {
            config = new ConfigBackgroundGmm();
        } else {
            config.checkValidity();
        }
        if (BoofConcurrency.isUseConcurrent()) {
            BackgroundMovingGmm backgroundMovingGmm;
            switch (imageType.getFamily()) {
                case GRAY: {
                    backgroundMovingGmm = new BackgroundMovingGmm_SB_MT<T, Motion>(config.learningPeriod, config.decayCoefient, config.numberOfGaussian, transform, imageType);
                    break;
                }
                case PLANAR: 
                case INTERLEAVED: {
                    backgroundMovingGmm = new BackgroundMovingGmm_MB_MT<T, Motion>(config.learningPeriod, config.decayCoefient, config.numberOfGaussian, transform, imageType);
                    break;
                }
                default: {
                    throw new IncompatibleClassChangeError();
                }
            }
            ret = backgroundMovingGmm;
        } else {
            BackgroundMovingGmm backgroundMovingGmm;
            switch (imageType.getFamily()) {
                case GRAY: {
                    backgroundMovingGmm = new BackgroundMovingGmm_SB<T, Motion>(config.learningPeriod, config.decayCoefient, config.numberOfGaussian, transform, imageType);
                    break;
                }
                case PLANAR: 
                case INTERLEAVED: {
                    backgroundMovingGmm = new BackgroundMovingGmm_MB<T, Motion>(config.learningPeriod, config.decayCoefient, config.numberOfGaussian, transform, imageType);
                    break;
                }
                default: {
                    throw new IncompatibleClassChangeError();
                }
            }
            ret = backgroundMovingGmm;
        }
        ret.setInitialVariance(config.initialVariance);
        ret.setMaxDistance(config.maxDistance);
        ret.setSignificantWeight(config.significantWeight);
        ret.setUnknownValue(config.unknownValue);
        return ret;
    }
}

