/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.tracker;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.abst.tracker.PointTrack;
import boofcv.abst.tracker.PointTrackerKltPyramid;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.alg.interpolate.InterpolateRectangle;
import boofcv.alg.tracker.klt.ConfigKlt;
import boofcv.alg.tracker.klt.KltTrackFault;
import boofcv.alg.tracker.klt.PyramidKltFeature;
import boofcv.alg.tracker.klt.PyramidKltTracker;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.ImageGray;
import boofcv.struct.pyramid.ImagePyramid;
import boofcv.struct.pyramid.PyramidDiscrete;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_I16;
import java.util.ArrayList;
import org.ddogleg.struct.DogArray_I32;
import pabeles.concurrency.GrowArray;

public class PointTrackerKltPyramid_MT<I extends ImageGray<I>, D extends ImageGray<D>>
extends PointTrackerKltPyramid<I, D> {
    public int minimumTracksConcurrent = 20;
    private final GrowArray<Helper> workspace;
    private final DogArray_I32 allFailed = new DogArray_I32();

    public PointTrackerKltPyramid_MT(ConfigKlt config, double toleranceFB, int templateRadius, boolean performPruneClose, PyramidDiscrete<I> pyramid, GeneralFeatureDetector<I, D> detector, ImageGradient<I, D> gradient, InterpolateRectangle<I> interpInput, InterpolateRectangle<D> interpDeriv, Class<D> derivType) {
        super(config, toleranceFB, templateRadius, performPruneClose, pyramid, detector, gradient, interpInput, interpDeriv, derivType);
        this.workspace = new GrowArray(() -> new Helper(), Helper::reset);
    }

    @Override
    protected void addToTracks(float scaleBottom, QueueCorner found) {
        int i;
        if (found.size() < this.minimumTracksConcurrent) {
            super.addToTracks(scaleBottom, found);
            return;
        }
        ArrayList<PyramidKltFeature> workTracks = new ArrayList<PyramidKltFeature>(found.size);
        for (i = 0; i < found.size; ++i) {
            workTracks.add(this.getUnusedTrack());
        }
        BoofConcurrency.loopBlocks((int)0, (int)workTracks.size(), this.workspace, (helper, idx0, idx1) -> {
            helper.tracker.setImage((ImagePyramid)this.currPyr.basePyramid, (ImageGray[])this.currPyr.derivX, (ImageGray[])this.currPyr.derivY);
            for (int detIdx = idx0; detIdx < idx1; ++detIdx) {
                Point2D_I16 pt = (Point2D_I16)found.get(detIdx);
                PyramidKltFeature t = (PyramidKltFeature)workTracks.get(detIdx);
                t.x = (float)pt.x * scaleBottom;
                t.y = (float)pt.y * scaleBottom;
                helper.tracker.setDescription(t);
                PointTrackerKltPyramid.PointTrackMod p = (PointTrackerKltPyramid.PointTrackMod)t.getCookie();
                p.pixel.setTo((double)t.x, (double)t.y);
                if (this.checkValidSpawn(p)) {
                    p.featureId = 1L;
                    p.spawnFrameID = this.frameID;
                    p.lastSeenFrameID = this.frameID;
                    p.prev.setTo((double)t.x, (double)t.y);
                    continue;
                }
                p.featureId = -1L;
            }
        });
        for (i = 0; i < workTracks.size(); ++i) {
            PyramidKltFeature t = (PyramidKltFeature)workTracks.get(i);
            PointTrackerKltPyramid.PointTrackMod p = (PointTrackerKltPyramid.PointTrackMod)t.getCookie();
            if (p.featureId == 1L) {
                ++this.totalFeatures;
                p.featureId = p.featureId;
                this.active.add(t);
                this.spawned.add(t);
                continue;
            }
            this.unused.add(t);
        }
    }

    @Override
    protected void trackFeatures(I image) {
        if (this.active.size() < this.minimumTracksConcurrent) {
            super.trackFeatures(image);
            return;
        }
        BoofConcurrency.loopBlocks((int)0, (int)this.active.size(), this.workspace, (helper, idx0, idx1) -> {
            helper.tracker.setImage((ImagePyramid)this.currPyr.basePyramid, (ImageGray[])this.currPyr.derivX, (ImageGray[])this.currPyr.derivY);
            for (int trackIdx = idx0; trackIdx < idx1; ++trackIdx) {
                PyramidKltFeature t = (PyramidKltFeature)this.active.get(trackIdx);
                KltTrackFault ret = helper.tracker.track(t);
                boolean success = false;
                if (ret == KltTrackFault.SUCCESS && image.isInBounds((int)t.x, (int)t.y) && helper.tracker.setDescription(t)) {
                    PointTrack p = (PointTrack)t.getCookie();
                    p.pixel.setTo((double)t.x, (double)t.y);
                    p.lastSeenFrameID = this.frameID;
                    success = true;
                }
                if (success) continue;
                helper.failed.add(trackIdx);
            }
        });
        this.dropFailed();
    }

    private void dropFailed() {
        this.allFailed.reset();
        for (int helpIdx = 0; helpIdx < this.workspace.size(); ++helpIdx) {
            this.allFailed.addAll(((Helper)this.workspace.get((int)helpIdx)).failed);
        }
        this.allFailed.sort();
        for (int allidx = this.allFailed.size - 1; allidx >= 0; --allidx) {
            int trackIdx = this.allFailed.get(allidx);
            PyramidKltFeature t = (PyramidKltFeature)this.active.get(trackIdx);
            this.active.remove(trackIdx);
            this.dropped.add(t);
            this.unused.add(t);
        }
    }

    @Override
    protected void backwardsTrackValidate() {
        if (this.active.size() < this.minimumTracksConcurrent) {
            super.backwardsTrackValidate();
            return;
        }
        double tol2 = this.toleranceFB * this.toleranceFB;
        BoofConcurrency.loopBlocks((int)0, (int)this.active.size(), this.workspace, (helper, idx0, idx1) -> {
            helper.tracker.setImage((ImagePyramid)this.prevPyr.basePyramid, (ImageGray[])this.prevPyr.derivX, (ImageGray[])this.prevPyr.derivY);
            for (int trackIdx = idx0; trackIdx < idx1; ++trackIdx) {
                PyramidKltFeature t = (PyramidKltFeature)this.active.get(trackIdx);
                PointTrackerKltPyramid.PointTrackMod p = (PointTrackerKltPyramid.PointTrackMod)t.getCookie();
                KltTrackFault ret = helper.tracker.track(t);
                if (ret != KltTrackFault.SUCCESS || p.prev.distance2((double)t.x, (double)t.y) > tol2) {
                    helper.failed.add(trackIdx);
                    continue;
                }
                p.prev.setTo((GeoTuple2D_F64)p.pixel);
                t.x = (float)p.pixel.x;
                t.y = (float)p.pixel.y;
            }
        });
        this.dropFailed();
    }

    private class Helper {
        PyramidKltTracker<I, D> tracker;
        DogArray_I32 failed;

        private Helper() {
            this.tracker = PointTrackerKltPyramid_MT.this.tracker.copyConcurrent();
            this.failed = new DogArray_I32();
        }

        public void reset() {
            this.failed.reset();
        }
    }
}

