/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.orientation.impl;

import boofcv.abst.feature.orientation.RegionOrientation;
import boofcv.alg.feature.orientation.OrientationImageAverage;
import boofcv.struct.image.GrayF32;

public class ImplOrientationImageAverage_F32
extends OrientationImageAverage<GrayF32> {
    public ImplOrientationImageAverage_F32(double objectToSample, int radius) {
        super(objectToSample, radius);
    }

    @Override
    public double computeAngle(int c_x, int c_y) {
        double sumX = 0.0;
        double sumY = 0.0;
        for (int y = this.rect.y0; y < this.rect.y1; ++y) {
            int index = ((GrayF32)this.image).startIndex + ((GrayF32)this.image).stride * y + this.rect.x0;
            int indexW = (y - c_y + this.sampleRadius) * this.kerCosine.width + this.rect.x0 - c_x + this.sampleRadius;
            int x = this.rect.x0;
            while (x < this.rect.x1) {
                float val = ((GrayF32)this.image).data[index];
                sumX += (double)(this.kerCosine.data[indexW] * val);
                sumY += (double)(this.kerSine.data[indexW] * val);
                ++x;
                ++index;
                ++indexW;
            }
        }
        return Math.atan2(sumY, sumX);
    }

    @Override
    public Class<GrayF32> getImageType() {
        return GrayF32.class;
    }

    @Override
    public RegionOrientation copy() {
        ImplOrientationImageAverage_F32 alg = new ImplOrientationImageAverage_F32(this.objectToSample, this.sampleRadius);
        alg.setObjectRadius(this.objectRadius);
        return alg;
    }
}

