/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.associate;

import boofcv.abst.feature.associate.AssociateDescTo2D;
import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.feature.associate.EnforceUniqueByScore;
import boofcv.abst.feature.associate.ScoreAssociateEuclideanSq;
import boofcv.abst.feature.associate.ScoreAssociateEuclidean_F64;
import boofcv.abst.feature.associate.ScoreAssociateHamming_B;
import boofcv.abst.feature.associate.ScoreAssociateNccFeature;
import boofcv.abst.feature.associate.ScoreAssociateSad;
import boofcv.abst.feature.associate.ScoreAssociation;
import boofcv.abst.feature.associate.WrapAssociateGreedy;
import boofcv.abst.feature.associate.WrapAssociateGreedy2D;
import boofcv.abst.feature.describe.DescriptorInfo;
import boofcv.alg.descriptor.KdTreeTuple_F32;
import boofcv.alg.descriptor.KdTreeTuple_F64;
import boofcv.alg.feature.associate.AssociateGreedyBase2D;
import boofcv.alg.feature.associate.AssociateGreedyBruteForce2D;
import boofcv.alg.feature.associate.AssociateGreedyBruteForce2D_MT;
import boofcv.alg.feature.associate.AssociateGreedyDesc;
import boofcv.alg.feature.associate.AssociateGreedyDescBase;
import boofcv.alg.feature.associate.AssociateGreedyDesc_MT;
import boofcv.alg.feature.associate.AssociateImageDistanceEuclideanSq;
import boofcv.alg.feature.associate.AssociateNearestNeighbor;
import boofcv.alg.feature.associate.AssociateNearestNeighbor_MT;
import boofcv.alg.feature.associate.AssociateNearestNeighbor_ST;
import boofcv.concurrency.BoofConcurrency;
import boofcv.factory.feature.associate.ConfigAssociate;
import boofcv.factory.feature.associate.ConfigAssociateGreedy;
import boofcv.factory.feature.associate.ConfigAssociateNearestNeighbor;
import boofcv.struct.ConfigLength;
import boofcv.struct.feature.NccFeature;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.feature.TupleDesc_B;
import boofcv.struct.feature.TupleDesc_F32;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.feature.TupleDesc_S8;
import boofcv.struct.feature.TupleDesc_U8;
import org.ddogleg.nn.FactoryNearestNeighbor;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.alg.KdTreeDistance;
import org.jetbrains.annotations.Nullable;

public class FactoryAssociation {
    public static <D> AssociateDescription<D> generic(ConfigAssociate config, DescriptorInfo info) {
        int DOF = info.createDescription().size();
        switch (config.type) {
            case GREEDY: {
                ScoreAssociation scorer = FactoryAssociation.defaultScore(info.getDescriptionType());
                return FactoryAssociation.greedy(config.greedy, scorer);
            }
            case KD_TREE: {
                return FactoryAssociation.kdtree(config.nearestNeighbor, DOF);
            }
            case RANDOM_FOREST: {
                return FactoryAssociation.kdRandomForest(config.nearestNeighbor, DOF, 10, 5, 1233445565L);
            }
        }
        throw new IllegalArgumentException("Unknown association: " + config.type);
    }

    public static <D> AssociateDescription2D<D> generic2(ConfigAssociate config, DescriptorInfo info) {
        if (config.maximumDistancePixels.fraction == 1.0) {
            return new AssociateDescTo2D<D>(FactoryAssociation.generic(config, info));
        }
        if (config.type == ConfigAssociate.AssociationType.GREEDY) {
            ScoreAssociation scorer = FactoryAssociation.defaultScore(info.getDescriptionType());
            return FactoryAssociation.greedy2D(config.greedy, config.maximumDistancePixels, scorer);
        }
        throw new IllegalArgumentException("Unknown association: " + config.type);
    }

    public static <D> AssociateDescription<D> ensureUnique(AssociateDescription<D> associate) {
        if (!associate.uniqueDestination() || !associate.uniqueSource()) {
            return new EnforceUniqueByScore.Describe<D>(associate, true, true);
        }
        return associate;
    }

    public static <D> AssociateDescription2D<D> ensureUnique(AssociateDescription2D<D> associate) {
        if (!associate.uniqueDestination() || !associate.uniqueSource()) {
            return new EnforceUniqueByScore.Describe2D<D>(associate, true, true);
        }
        return associate;
    }

    public static <D> AssociateDescription<D> greedy(@Nullable ConfigAssociateGreedy config, ScoreAssociation<D> score) {
        if (config == null) {
            config = new ConfigAssociateGreedy();
        }
        AssociateGreedyDescBase alg = BoofConcurrency.USE_CONCURRENT ? new AssociateGreedyDesc_MT<D>(score) : new AssociateGreedyDesc<D>(score);
        alg.setBackwardsValidation(config.forwardsBackwards);
        alg.setMaxFitError(config.maxErrorThreshold);
        alg.setRatioTest(config.scoreRatioThreshold);
        return new WrapAssociateGreedy(alg);
    }

    public static <D> AssociateDescription2D<D> greedy2D(@Nullable ConfigAssociateGreedy config, ConfigLength maxDistance, ScoreAssociation<D> score) {
        if (config == null) {
            config = new ConfigAssociateGreedy();
        }
        AssociateImageDistanceEuclideanSq distance = new AssociateImageDistanceEuclideanSq();
        AssociateGreedyBase2D alg = BoofConcurrency.USE_CONCURRENT ? new AssociateGreedyBruteForce2D_MT<D>(score, distance) : new AssociateGreedyBruteForce2D<D>(score, distance);
        alg.getMaxDistanceLength().setTo(maxDistance);
        alg.setBackwardsValidation(config.forwardsBackwards);
        alg.setMaxFitError(config.maxErrorThreshold);
        alg.setRatioTest(config.scoreRatioThreshold);
        return new WrapAssociateGreedy2D(alg);
    }

    public static AssociateDescription<TupleDesc_F64> kdtree(@Nullable ConfigAssociateNearestNeighbor configNN, int dimension) {
        if (configNN == null) {
            configNN = new ConfigAssociateNearestNeighbor();
        }
        NearestNeighbor nn = FactoryNearestNeighbor.kdtree((KdTreeDistance)new KdTreeTuple_F64(dimension), (int)configNN.maxNodesSearched);
        return FactoryAssociation.associateNearestNeighbor(configNN, nn);
    }

    public static AssociateDescription<TupleDesc_F64> kdRandomForest(@Nullable ConfigAssociateNearestNeighbor configNN, int dimension, int numTrees, int numConsiderSplit, long randomSeed) {
        if (configNN == null) {
            configNN = new ConfigAssociateNearestNeighbor();
        }
        NearestNeighbor nn = FactoryNearestNeighbor.kdRandomForest((KdTreeDistance)new KdTreeTuple_F64(dimension), (int)configNN.maxNodesSearched, (int)numTrees, (int)numConsiderSplit, (long)randomSeed);
        return FactoryAssociation.associateNearestNeighbor(configNN, nn);
    }

    public static <TD extends TupleDesc<TD>> KdTreeDistance<TD> kdtreeDistance(int dof, Class<TD> type) {
        if (type == TupleDesc_F64.class) {
            return new KdTreeTuple_F64(dof);
        }
        if (type == TupleDesc_F32.class) {
            return new KdTreeTuple_F32(dof);
        }
        throw new IllegalArgumentException("Type isn't known yet");
    }

    public static AssociateNearestNeighbor<TupleDesc_F64> associateNearestNeighbor(@Nullable ConfigAssociateNearestNeighbor config, NearestNeighbor nn) {
        if (config == null) {
            config = new ConfigAssociateNearestNeighbor();
        }
        config.checkValidity();
        AssociateNearestNeighbor assoc = BoofConcurrency.USE_CONCURRENT ? new AssociateNearestNeighbor_MT<TupleDesc_F64>(nn, TupleDesc_F64.class) : new AssociateNearestNeighbor_ST<TupleDesc_F64>(nn, TupleDesc_F64.class);
        assoc.setRatioUsesSqrt(config.distanceIsSquared);
        assoc.setMaxScoreThreshold(config.maxErrorThreshold);
        assoc.setScoreRatioThreshold(config.scoreRatioThreshold);
        return assoc;
    }

    public static <D> ScoreAssociation<D> defaultScore(Class<D> tupleType) {
        if (NccFeature.class.isAssignableFrom(tupleType)) {
            return new ScoreAssociateNccFeature();
        }
        if (TupleDesc_F64.class.isAssignableFrom(tupleType)) {
            return new ScoreAssociateEuclideanSq.F64();
        }
        if (tupleType == TupleDesc_F32.class) {
            return new ScoreAssociateEuclideanSq.F32();
        }
        if (tupleType == TupleDesc_U8.class) {
            return new ScoreAssociateSad.U8();
        }
        if (tupleType == TupleDesc_B.class) {
            return new ScoreAssociateHamming_B();
        }
        throw new IllegalArgumentException("Unknown tuple type: " + tupleType);
    }

    public static <D> ScoreAssociation<D> scoreSad(Class<D> tupleType) {
        if (TupleDesc_F64.class.isAssignableFrom(tupleType)) {
            return new ScoreAssociateSad.F64();
        }
        if (tupleType == TupleDesc_F32.class) {
            return new ScoreAssociateSad.F32();
        }
        if (tupleType == TupleDesc_U8.class) {
            return new ScoreAssociateSad.U8();
        }
        if (tupleType == TupleDesc_S8.class) {
            return new ScoreAssociateSad.S8();
        }
        throw new IllegalArgumentException("SAD score not supported for type " + tupleType.getSimpleName());
    }

    public static ScoreAssociation<NccFeature> scoreNcc() {
        return new ScoreAssociateNccFeature();
    }

    public static <D> ScoreAssociation<D> scoreEuclidean(Class<D> tupleType, boolean squared) {
        if (TupleDesc_F64.class.isAssignableFrom(tupleType)) {
            if (squared) {
                return new ScoreAssociateEuclideanSq.F64();
            }
            return new ScoreAssociateEuclidean_F64();
        }
        if (tupleType == TupleDesc_F32.class && squared) {
            return new ScoreAssociateEuclideanSq.F32();
        }
        throw new IllegalArgumentException("Euclidean score not yet supported for type " + tupleType.getSimpleName());
    }

    public static <D> ScoreAssociation<D> scoreHamming(Class<D> tupleType) {
        if (tupleType == TupleDesc_B.class) {
            return new ScoreAssociateHamming_B();
        }
        throw new IllegalArgumentException("Hamming distance not yet supported for type " + tupleType.getSimpleName());
    }
}

