/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.feature;

import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;

public class ScalePoint {
    public final Point2D_F64 pixel = new Point2D_F64();
    public double scale;
    public boolean white;
    public float intensity = Float.NaN;

    public ScalePoint(double x, double y, double scale) {
        this.pixel.setTo(x, y);
        this.scale = scale;
    }

    public ScalePoint(double x, double y, double scale, boolean white) {
        this.setTo(x, y, scale, white);
    }

    public ScalePoint() {
    }

    public void setTo(double x, double y, double scale) {
        this.pixel.setTo(x, y);
        this.scale = scale;
        this.intensity = Float.NaN;
    }

    public void setTo(double x, double y, double scale, boolean white) {
        this.pixel.setTo(x, y);
        this.scale = scale;
        this.white = white;
        this.intensity = Float.NaN;
    }

    public void setTo(double x, double y, double scale, boolean white, float intensity) {
        this.pixel.setTo(x, y);
        this.scale = scale;
        this.white = white;
        this.intensity = intensity;
    }

    public ScalePoint copy() {
        ScalePoint ret = new ScalePoint();
        ret.setTo(this);
        return ret;
    }

    public void setTo(ScalePoint p) {
        this.scale = p.scale;
        this.pixel.setTo((GeoTuple2D_F64)p.pixel);
        this.white = p.white;
        this.intensity = p.intensity;
    }

    public String toString() {
        return "ScalePoint{pixel=" + this.pixel + ", scale=" + this.scale + ", white=" + this.white + ", intensity=" + this.intensity + "}";
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public boolean isWhite() {
        return this.white;
    }

    public void setWhite(boolean white) {
        this.white = white;
    }

    public float getIntensity() {
        return this.intensity;
    }

    public void setIntensity(float intensity) {
        this.intensity = intensity;
    }
}

