/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.stationary;

import boofcv.alg.background.stationary.BackgroundStationaryGaussian;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.core.image.FactoryGImageMultiBand;
import boofcv.core.image.GConvertImage;
import boofcv.core.image.GImageMultiBand;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import pabeles.concurrency.GrowArray;

public class BackgroundStationaryGaussian_PL<T extends ImageGray<T>>
extends BackgroundStationaryGaussian<Planar<T>> {
    protected GImageMultiBand inputWrapper;
    protected GImageMultiBand bgWrapper;
    GrowArray<float[]> storageInput;
    Planar<GrayF32> background;

    public BackgroundStationaryGaussian_PL(float learnRate, float threshold, ImageType<Planar<T>> imageType) {
        super(learnRate, threshold, imageType);
        int numBands = imageType.getNumBands();
        this.background = new Planar(GrayF32.class, 0, 0, 2 * numBands);
        this.bgWrapper = FactoryGImageMultiBand.create((ImageType)this.background.getImageType());
        this.bgWrapper.wrap(this.background);
        this.inputWrapper = FactoryGImageMultiBand.create(imageType);
        this.storageInput = new GrowArray(() -> new float[numBands]);
    }

    @Override
    public void reset() {
        this.background.reshape(0, 0);
    }

    @Override
    public void updateBackground(Planar<T> frame) {
        if (this.background.width != frame.width || this.background.height != frame.height) {
            this.background.reshape(frame.width, frame.height);
            for (int band = 0; band < this.background.getNumBands(); band += 2) {
                GConvertImage.convert((ImageBase)frame.getBand(band / 2), (ImageBase)this.background.getBand(band));
                GImageMiscOps.fill((ImageBase)this.background.getBand(band + 1), (double)this.initialVariance);
            }
            return;
        }
        this.inputWrapper.wrap(frame);
        int numBands = this.background.getNumBands() / 2;
        float minusLearn = 1.0f - this.learnRate;
        this.storageInput.reset();
        boolean idx0 = false;
        int idx1 = frame.height;
        float[] inputPixel = (float[])this.storageInput.grow();
        for (int y = 0; y < idx1; ++y) {
            int indexBG = y * this.background.width;
            int indexInput = frame.startIndex + y * frame.stride;
            int end = indexInput + frame.width;
            while (indexInput < end) {
                this.inputWrapper.getF(indexInput, inputPixel);
                for (int band = 0; band < numBands; ++band) {
                    GrayF32 backgroundMean = (GrayF32)this.background.getBand(band * 2);
                    GrayF32 backgroundVar = (GrayF32)this.background.getBand(band * 2 + 1);
                    float inputValue = inputPixel[band];
                    float meanBG = backgroundMean.data[indexBG];
                    float varianceBG = backgroundVar.data[indexBG];
                    float diff = meanBG - inputValue;
                    backgroundMean.data[indexBG] = minusLearn * meanBG + this.learnRate * inputValue;
                    backgroundVar.data[indexBG] = minusLearn * varianceBG + this.learnRate * diff * diff;
                }
                ++indexInput;
                ++indexBG;
            }
        }
    }

    @Override
    public void segment(Planar<T> frame, GrayU8 segmented) {
        segmented.reshape(frame.width, frame.height);
        if (this.background.width != frame.width || this.background.height != frame.height) {
            ImageMiscOps.fill((GrayI8)segmented, (int)this.unknownValue);
            return;
        }
        this.inputWrapper.wrap(frame);
        int numBands = this.background.getNumBands() / 2;
        float adjustedMinimumDifference = this.minimumDifference * (float)numBands;
        this.storageInput.reset();
        boolean idx0 = false;
        int idx1 = frame.height;
        float[] inputPixel = (float[])this.storageInput.grow();
        for (int y = 0; y < idx1; ++y) {
            int indexBG = y * this.background.width;
            int indexInput = frame.startIndex + y * frame.stride;
            int indexSegmented = segmented.startIndex + y * segmented.stride;
            int end = indexInput + frame.width;
            while (indexInput < end) {
                this.inputWrapper.getF(indexInput, inputPixel);
                float mahalanobis = 0.0f;
                for (int band = 0; band < numBands; ++band) {
                    GrayF32 backgroundMean = (GrayF32)this.background.getBand(band * 2);
                    GrayF32 backgroundVar = (GrayF32)this.background.getBand(band * 2 + 1);
                    float meanBG = backgroundMean.data[indexBG];
                    float varBG = backgroundVar.data[indexBG];
                    float diff = meanBG - inputPixel[band];
                    mahalanobis += diff * diff / varBG;
                }
                if (mahalanobis <= this.threshold) {
                    segmented.data[indexSegmented] = 0;
                } else if (this.minimumDifference == 0.0f) {
                    segmented.data[indexSegmented] = 1;
                } else {
                    float sumAbsDiff = 0.0f;
                    for (int band = 0; band < numBands; ++band) {
                        GrayF32 backgroundMean = (GrayF32)this.background.getBand(band * 2);
                        sumAbsDiff += Math.abs(backgroundMean.data[indexBG] - inputPixel[band]);
                    }
                    segmented.data[indexSegmented] = (byte)(sumAbsDiff >= adjustedMinimumDifference ? 1 : 0);
                }
                ++indexInput;
                ++indexSegmented;
                ++indexBG;
            }
        }
    }
}

