/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.associate;

import boofcv.abst.feature.associate.ScoreAssociation;
import org.ddogleg.struct.DogArray_F64;
import org.ddogleg.struct.DogArray_I32;
import org.ejml.data.DMatrixRMaj;

public abstract class AssociateGreedyBase<D> {
    ScoreAssociation<D> score;
    double maxFitError = Double.MAX_VALUE;
    DogArray_F64 fitQuality = new DogArray_F64(100);
    DogArray_I32 pairs = new DogArray_I32(100);
    DMatrixRMaj scoreMatrix = new DMatrixRMaj(1, 1);
    boolean backwardsValidation = false;
    double ratioTest = 1.0;

    AssociateGreedyBase(ScoreAssociation<D> score) {
        this.score = score;
    }

    protected void setupForAssociate(int sizeSrc, int sizeDst) {
        this.fitQuality.reset();
        this.pairs.reset();
        this.pairs.resize(sizeSrc);
        this.fitQuality.resize(sizeSrc);
        this.scoreMatrix.reshape(sizeSrc, sizeDst);
    }

    public final void forwardsBackwards(int indexSrc, int sizeSrc, int sizeDst) {
        int indexDst = this.pairs.data[indexSrc];
        if (indexDst == -1) {
            return;
        }
        double scoreToBeat = this.scoreMatrix.data[indexSrc * sizeDst + indexDst];
        int indexScore = indexDst;
        int indexSrcCmp = 0;
        while (indexSrcCmp < sizeSrc) {
            if (this.scoreMatrix.data[indexScore] <= scoreToBeat && indexSrcCmp != indexSrc) {
                this.pairs.data[indexSrc] = -1;
                this.fitQuality.data[indexSrc] = Double.MAX_VALUE;
                break;
            }
            ++indexSrcCmp;
            indexScore += sizeDst;
        }
    }

    public void setMaxFitError(double maxFitError) {
        this.maxFitError = maxFitError <= 0.0 ? Double.MAX_VALUE : maxFitError;
    }

    public ScoreAssociation<D> getScore() {
        return this.score;
    }

    public double getMaxFitError() {
        return this.maxFitError;
    }

    public DogArray_F64 getFitQuality() {
        return this.fitQuality;
    }

    public DogArray_I32 getPairs() {
        return this.pairs;
    }

    public DMatrixRMaj getScoreMatrix() {
        return this.scoreMatrix;
    }

    public boolean isBackwardsValidation() {
        return this.backwardsValidation;
    }

    public void setBackwardsValidation(boolean backwardsValidation) {
        this.backwardsValidation = backwardsValidation;
    }

    public double getRatioTest() {
        return this.ratioTest;
    }

    public void setRatioTest(double ratioTest) {
        this.ratioTest = ratioTest;
    }
}

