/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.feature;

import boofcv.misc.BoofLambdas;
import boofcv.struct.PackedArray;
import boofcv.struct.feature.TupleDesc_B;
import org.ddogleg.struct.BigDogArray_I32;
import org.ddogleg.struct.BigDogGrowth;

public class PackedTupleBigArray_B
implements PackedArray<TupleDesc_B> {
    public final int dof;
    public final BigDogArray_I32 array;
    public final TupleDesc_B temp;
    protected int numElements;
    protected final int numInts;

    public PackedTupleBigArray_B(int dof) {
        this.dof = dof;
        this.temp = new TupleDesc_B(dof);
        this.numInts = this.temp.data.length;
        this.array = new BigDogArray_I32(dof, dof / 32 * 65536, BigDogGrowth.GROW_FIRST);
        this.array.resize(0);
    }

    public void reset() {
        this.numElements = 0;
        this.array.reset();
    }

    public void reserve(int numTuples) {
        this.array.reserve(numTuples * this.numInts);
    }

    public void append(TupleDesc_B element) {
        this.array.append((Object)element.data, 0, this.numInts);
        ++this.numElements;
    }

    public TupleDesc_B getTemp(int index) {
        this.array.getArray(index * this.numInts, this.temp.data, 0, this.numInts);
        return this.temp;
    }

    public void getCopy(int index, TupleDesc_B dst) {
        this.array.getArray(index * this.numInts, dst.data, 0, this.numInts);
    }

    public void copy(TupleDesc_B src, TupleDesc_B dst) {
        System.arraycopy(src.data, 0, dst.data, 0, this.numInts);
    }

    public int size() {
        return this.numElements;
    }

    public Class<TupleDesc_B> getElementType() {
        return TupleDesc_B.class;
    }

    public void forIdx(int idx0, int idx1, BoofLambdas.ProcessIndex<TupleDesc_B> op) {
        this.array.processByBlock(idx0 * this.numInts, idx1 * this.numInts, (array, arrayIdx0, arrayIdx1, offset) -> {
            int pointIndex = idx0 + offset / this.numInts;
            for (int i = arrayIdx0; i < arrayIdx1; i += this.numInts) {
                System.arraycopy(array, i, this.temp.data, 0, this.numInts);
                op.process(pointIndex++, (Object)this.temp);
            }
        });
    }
}

