/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.segmentation.cc;

import boofcv.alg.misc.ImageMiscOps;
import boofcv.alg.segmentation.cc.ConnectedSpeckleFiller;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import org.ddogleg.struct.DogArray;

public class ConnectedNaiveSpeckleFiller_F32
implements ConnectedSpeckleFiller<GrayF32> {
    GrayS32 labels = new GrayS32(1, 1);
    DogArray<Pixel> open = new DogArray(Pixel::new);
    int totalFilled;
    int totalRegions;
    float similarTolerance;
    float fillValue;

    @Override
    public void process(GrayF32 image, int maximumArea, double similarTol, double fillValue) {
        this.similarTolerance = (float)similarTol;
        this.fillValue = (float)fillValue;
        this.totalFilled = 0;
        this.labels.reshape((ImageBase)image);
        ImageMiscOps.fill((GrayS32)this.labels, (int)-1);
        this.totalRegions = 0;
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                float value;
                int label = this.labels.unsafe_get(x, y);
                if (label != -1 || (double)(value = image.unsafe_get(x, y)) == fillValue || this.applyLabel(image, x, y, value) > maximumArea) continue;
                for (int i = 0; i < this.open.size; ++i) {
                    Pixel p = (Pixel)this.open.get(i);
                    image.unsafe_set(p.x, p.y, this.fillValue);
                }
                ++this.totalFilled;
            }
        }
    }

    @Override
    public int getTotalFilled() {
        return this.totalFilled;
    }

    @Override
    public ImageType<GrayF32> getImageType() {
        return ImageType.SB_F32;
    }

    int applyLabel(GrayF32 image, int seedX, int seedY, float seedValue) {
        int location;
        int label = this.totalRegions++;
        this.open.reset();
        ((Pixel)this.open.grow()).setTo(seedX, seedY, seedValue);
        this.labels.unsafe_set(seedX, seedY, label);
        for (location = 0; location < this.open.size(); ++location) {
            Pixel p = (Pixel)this.open.get(location);
            int x = p.x;
            int y = p.y;
            float value = p.value;
            this.checkAdd(image, x + 1, y, label, value);
            this.checkAdd(image, x, y + 1, label, value);
            this.checkAdd(image, x - 1, y, label, value);
            this.checkAdd(image, x, y - 1, label, value);
        }
        return location;
    }

    private void checkAdd(GrayF32 image, int x, int y, int label, float targetValue) {
        if (!this.labels.isInBounds(x, y)) {
            return;
        }
        if (this.labels.unsafe_get(x, y) != -1) {
            return;
        }
        float value = image.unsafe_get(x, y);
        if (value == this.fillValue || Math.abs(targetValue - value) > this.similarTolerance) {
            return;
        }
        this.labels.unsafe_set(x, y, label);
        ((Pixel)this.open.grow()).setTo(x, y, value);
    }

    public static class Pixel {
        int x;
        int y;
        float value;

        public void setTo(int x, int y, float value) {
            this.x = x;
            this.y = y;
            this.value = value;
        }
    }
}

