/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.stationary;

import boofcv.alg.background.stationary.BackgroundStationaryGmm;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import org.jetbrains.annotations.Nullable;

public class BackgroundStationaryGmm_SB_MT<T extends ImageGray<T>>
extends BackgroundStationaryGmm<T> {
    public BackgroundStationaryGmm_SB_MT(float learningPeriod, float decayCoef, int maxGaussians, ImageType<T> imageType) {
        super(learningPeriod, decayCoef, maxGaussians, imageType);
    }

    @Override
    public void updateBackground(T frame, @Nullable GrayU8 mask) {
        super.updateBackground(frame, mask);
        this.common.inputWrapperG.wrap(frame);
        BoofConcurrency.loopFor((int)0, (int)this.common.imageHeight, row -> {
            int inputIndex = frame.startIndex + row * frame.stride;
            float[] dataRow = this.common.model.data[row];
            if (mask == null) {
                for (int col = 0; col < this.common.imageWidth; ++col) {
                    float pixelValue = this.common.inputWrapperG.getF(inputIndex++);
                    int modelIndex = col * this.common.modelStride;
                    this.common.updateMixture(pixelValue, dataRow, modelIndex);
                }
            } else {
                int indexMask = mask.startIndex + row * mask.stride;
                for (int col = 0; col < this.common.imageWidth; ++col) {
                    float pixelValue = this.common.inputWrapperG.getF(inputIndex++);
                    int modelIndex = col * this.common.modelStride;
                    mask.data[indexMask++] = (byte)this.common.updateMixture(pixelValue, dataRow, modelIndex);
                }
            }
        });
    }

    @Override
    public void segment(T frame, GrayU8 segmented) {
        segmented.reshape(((ImageGray)frame).width, ((ImageGray)frame).height);
        if (this.common.imageWidth != ((ImageGray)frame).width || this.common.imageHeight != ((ImageGray)frame).height) {
            ImageMiscOps.fill((GrayI8)segmented, (int)this.unknownValue);
            return;
        }
        this.common.unknownValue = this.unknownValue;
        this.common.inputWrapperG.wrap(frame);
        BoofConcurrency.loopFor((int)0, (int)this.common.imageHeight, row -> {
            int indexIn = frame.startIndex + row * frame.stride;
            int indexOut = segmented.startIndex + row * segmented.stride;
            float[] dataRow = this.common.model.data[row];
            for (int col = 0; col < this.common.imageWidth; ++col) {
                float pixelValue = this.common.inputWrapperG.getF(indexIn++);
                int modelIndex = col * this.common.modelStride;
                segmented.data[indexOut++] = (byte)this.common.checkBackground(pixelValue, dataRow, modelIndex);
            }
        });
    }
}

