/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.describe;

import boofcv.abst.feature.describe.DescribePoint;
import boofcv.abst.feature.describe.DescribePointRadiusAngle;
import boofcv.abst.feature.orientation.OrientationImage;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class DescribeRadiusAngle_Point<T extends ImageGray<T>, TD extends TupleDesc<TD>>
implements DescribePoint<T, TD> {
    public double regionRadius;
    DescribePointRadiusAngle<T, TD> describer;
    OrientationImage<T> orientationEstimator;

    public DescribeRadiusAngle_Point(DescribePointRadiusAngle<T, TD> describer, OrientationImage<T> orientationEstimator, double regionRadius) {
        this.describer = describer;
        this.orientationEstimator = orientationEstimator;
        this.regionRadius = regionRadius;
    }

    @Override
    public void setImage(T image) {
        if (this.regionRadius <= 0.0) {
            this.regionRadius = this.describer.getCanonicalWidth() / 2.0;
        }
        this.orientationEstimator.setObjectRadius(this.regionRadius);
        this.describer.setImage(image);
        this.orientationEstimator.setImage(image);
    }

    @Override
    public boolean process(double x, double y, TD description) {
        double angle = this.orientationEstimator.compute(x, y);
        return this.describer.process(x, y, angle, this.regionRadius, description);
    }

    @Override
    public ImageType<T> getImageType() {
        return this.describer.getImageType();
    }

    @Override
    public TD createDescription() {
        return (TD)this.describer.createDescription();
    }

    @Override
    public Class<TD> getDescriptionType() {
        return this.describer.getDescriptionType();
    }

    public DescribePointRadiusAngle<T, TD> getDescriber() {
        return this.describer;
    }

    public OrientationImage<T> getOrientationEstimator() {
        return this.orientationEstimator;
    }
}

