/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.stationary;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.background.stationary.BackgroundStationaryBasic;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.concurrency.BoofConcurrency;
import boofcv.core.image.FactoryGImageGray;
import boofcv.core.image.GConvertImage;
import boofcv.core.image.GImageGray;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class BackgroundStationaryBasic_SB_MT<T extends ImageGray<T>>
extends BackgroundStationaryBasic<T> {
    protected GrayF32 background = new GrayF32(0, 0);
    protected GImageGray inputWrapper;

    public BackgroundStationaryBasic_SB_MT(float learnRate, float threshold, Class<T> imageType) {
        super(learnRate, threshold, ImageType.single(imageType));
        this.inputWrapper = FactoryGImageGray.create(imageType);
    }

    @Override
    public void reset() {
        this.background.reshape(0, 0);
    }

    @Override
    public void updateBackground(T frame) {
        if (this.background.width != ((ImageGray)frame).width) {
            this.background.reshape(((ImageGray)frame).width, ((ImageGray)frame).height);
            GConvertImage.convert(frame, (ImageBase)this.background);
            return;
        }
        InputSanityCheck.checkSameShape((ImageBase)this.background, frame);
        this.inputWrapper.wrap(frame);
        float minusLearn = 1.0f - this.learnRate;
        float[] backgroundData = this.background.data;
        BoofConcurrency.loopFor((int)0, (int)((ImageGray)frame).height, y -> {
            int indexBG = y * frame.width;
            int indexInput = frame.startIndex + y * frame.stride;
            int end = indexInput + frame.width;
            while (indexInput < end) {
                float value = this.inputWrapper.getF(indexInput++);
                float bg = backgroundData[indexBG];
                backgroundData[indexBG++] = minusLearn * bg + this.learnRate * value;
            }
        });
    }

    @Override
    public void segment(T frame, GrayU8 segmented) {
        segmented.reshape(((ImageGray)frame).width, ((ImageGray)frame).height);
        if (this.background.width != ((ImageGray)frame).width || this.background.height != ((ImageGray)frame).height) {
            ImageMiscOps.fill((GrayI8)segmented, (int)this.unknownValue);
            return;
        }
        this.inputWrapper.wrap(frame);
        float thresholdSq = this.threshold * this.threshold;
        byte[] segmentedData = segmented.data;
        float[] backgroundData = this.background.data;
        BoofConcurrency.loopFor((int)0, (int)((ImageGray)frame).height, y -> {
            int indexBG = y * frame.width;
            int indexInput = frame.startIndex + y * frame.stride;
            int indexSegmented = segmented.startIndex + y * segmented.stride;
            int end = indexInput + frame.width;
            while (indexInput < end) {
                float bg = backgroundData[indexBG++];
                float pixelFrame = this.inputWrapper.getF(indexInput++);
                float diff = bg - pixelFrame;
                segmentedData[indexSegmented++] = (byte)(!(diff * diff <= thresholdSq) ? 1 : 0);
            }
        });
    }

    public GrayF32 getBackground() {
        return this.background;
    }
}

