/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.stationary;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.background.stationary.BackgroundStationaryGaussian;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.concurrency.BoofConcurrency;
import boofcv.core.image.FactoryGImageGray;
import boofcv.core.image.GConvertImage;
import boofcv.core.image.GImageGray;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;

public class BackgroundStationaryGaussian_SB_MT<T extends ImageGray<T>>
extends BackgroundStationaryGaussian<T> {
    protected GImageGray inputWrapper;
    Planar<GrayF32> background = new Planar(GrayF32.class, 0, 0, 2);

    public BackgroundStationaryGaussian_SB_MT(float learnRate, float threshold, Class<T> imageType) {
        super(learnRate, threshold, ImageType.single(imageType));
        this.inputWrapper = FactoryGImageGray.create(imageType);
    }

    @Override
    public void reset() {
        this.background.reshape(0, 0);
    }

    @Override
    public void updateBackground(T frame) {
        if (this.background.width != ((ImageGray)frame).width || this.background.height != ((ImageGray)frame).height) {
            this.background.reshape(((ImageGray)frame).width, ((ImageGray)frame).height);
            GConvertImage.convert(frame, (ImageBase)this.background.getBand(0));
            GImageMiscOps.fill((ImageBase)this.background.getBand(1), (double)this.initialVariance);
            return;
        }
        this.inputWrapper.wrap(frame);
        float minusLearn = 1.0f - this.learnRate;
        GrayF32 backgroundMean = (GrayF32)this.background.getBand(0);
        GrayF32 backgroundVar = (GrayF32)this.background.getBand(1);
        BoofConcurrency.loopFor((int)0, (int)((ImageGray)frame).height, y -> {
            int indexInput;
            int indexBG = y * this.background.width;
            int end = indexInput + frame.width;
            for (indexInput = frame.startIndex + y * frame.stride; indexInput < end; ++indexInput) {
                float inputValue = this.inputWrapper.getF(indexInput);
                float meanBG = backgroundMean.data[indexBG];
                float varianceBG = backgroundVar.data[indexBG];
                float diff = meanBG - inputValue;
                backgroundMean.data[indexBG] = minusLearn * meanBG + this.learnRate * inputValue;
                backgroundVar.data[indexBG] = minusLearn * varianceBG + this.learnRate * diff * diff;
                ++indexBG;
            }
        });
    }

    @Override
    public void segment(T frame, GrayU8 segmented) {
        segmented.reshape(((ImageGray)frame).width, ((ImageGray)frame).height);
        if (this.background.width != ((ImageGray)frame).width || this.background.height != ((ImageGray)frame).height) {
            ImageMiscOps.fill((GrayI8)segmented, (int)this.unknownValue);
            return;
        }
        InputSanityCheck.checkSameShape(this.background, frame, (ImageBase)segmented);
        this.inputWrapper.wrap(frame);
        GrayF32 backgroundMean = (GrayF32)this.background.getBand(0);
        GrayF32 backgroundVar = (GrayF32)this.background.getBand(1);
        BoofConcurrency.loopFor((int)0, (int)((ImageGray)frame).height, y -> {
            int indexBG = y * this.background.width;
            int indexInput = frame.startIndex + y * frame.stride;
            int indexSegmented = segmented.startIndex + y * segmented.stride;
            int end = indexInput + frame.width;
            while (indexInput < end) {
                float varBG;
                float meanBG = backgroundMean.data[indexBG];
                float pixelFrame = this.inputWrapper.getF(indexInput);
                float diff = meanBG - pixelFrame;
                float chisq = diff * diff / (varBG = backgroundVar.data[indexBG]);
                segmented.data[indexSegmented] = chisq <= this.threshold ? (byte)0 : (diff >= this.minimumDifference || -diff >= this.minimumDifference ? (byte)1 : (byte)0);
                ++indexInput;
                ++indexSegmented;
                ++indexBG;
            }
        });
    }
}

