/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.describe.impl;

import boofcv.alg.feature.describe.DescribePointBinaryCompare;
import boofcv.alg.feature.describe.brief.BinaryCompareDefinition_I32;
import boofcv.struct.feature.TupleDesc_B;
import boofcv.struct.image.GrayU8;
import georegression.struct.point.Point2D_I32;
import java.util.Arrays;

public class ImplDescribeBinaryCompare_U8
extends DescribePointBinaryCompare<GrayU8> {
    public ImplDescribeBinaryCompare_U8(BinaryCompareDefinition_I32 definition) {
        super(definition);
    }

    @Override
    public void processInside(int c_x, int c_y, TupleDesc_B feature) {
        Arrays.fill(feature.data, 0);
        int index = ((GrayU8)this.image).startIndex + ((GrayU8)this.image).stride * c_y + c_x;
        for (int i = 0; i < this.definition.compare.length; i += 32) {
            int end = Math.min(this.definition.compare.length, i + 32);
            int valA = ((GrayU8)this.image).data[index + this.offsetsA[i]] & 0xFF;
            int valB = ((GrayU8)this.image).data[index + this.offsetsB[i]] & 0xFF;
            int desc = valA < valB ? 1 : 0;
            for (int j = i + 1; j < end; ++j) {
                valA = ((GrayU8)this.image).data[index + this.offsetsA[j]] & 0xFF;
                valB = ((GrayU8)this.image).data[index + this.offsetsB[j]] & 0xFF;
                desc *= 2;
                if (valA >= valB) continue;
                ++desc;
            }
            feature.data[i / 32] = desc;
        }
    }

    @Override
    public void processBorder(int c_x, int c_y, TupleDesc_B feature) {
        Arrays.fill(feature.data, 0);
        int index = ((GrayU8)this.image).startIndex + ((GrayU8)this.image).stride * c_y + c_x;
        for (int i = 0; i < this.definition.compare.length; i += 32) {
            int end = Math.min(this.definition.compare.length, i + 32);
            int desc = 0;
            for (int j = i; j < end; ++j) {
                int valB;
                int valA;
                Point2D_I32 c = this.definition.compare[j];
                Point2D_I32 p_a = this.definition.samplePoints[c.x];
                Point2D_I32 p_b = this.definition.samplePoints[c.y];
                desc *= 2;
                if (!((GrayU8)this.image).isInBounds(p_a.x + c_x, p_a.y + c_y) || !((GrayU8)this.image).isInBounds(p_b.x + c_x, p_b.y + c_y) || (valA = ((GrayU8)this.image).data[index + this.offsetsA[j]] & 0xFF) >= (valB = ((GrayU8)this.image).data[index + this.offsetsB[j]] & 0xFF)) continue;
                ++desc;
            }
            feature.data[i / 32] = desc;
        }
    }
}

