/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.background.moving;

import boofcv.alg.background.moving.BackgroundMovingBasic;
import boofcv.alg.interpolate.InterpolatePixelMB;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.core.image.FactoryGImageMultiBand;
import boofcv.core.image.GImageMultiBand;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.border.BorderType;
import boofcv.struct.distort.Point2Transform2Model_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import georegression.struct.InvertibleTransform;
import georegression.struct.point.Point2D_F32;
import pabeles.concurrency.GrowArray;

public class BackgroundMovingBasic_PL<T extends ImageGray<T>, Motion extends InvertibleTransform<Motion>>
extends BackgroundMovingBasic<Planar<T>, Motion> {
    Planar<GrayF32> background;
    protected InterpolatePixelMB<Planar<T>> _interpolationInput;
    protected InterpolatePixelMB<Planar<GrayF32>> _interpolationBG;
    protected GImageMultiBand backgroundWrapper;
    protected GImageMultiBand inputWrapper;
    protected GrowArray<Helper> helpers;
    protected Helper helper;

    public BackgroundMovingBasic_PL(float learnRate, float threshold, Point2Transform2Model_F32<Motion> transform, InterpolationType interpType, ImageType<Planar<T>> imageType) {
        super(learnRate, threshold, transform, imageType);
        this._interpolationInput = FactoryInterpolation.createPixelMB((double)0.0, (double)255.0, (InterpolationType)interpType, (BorderType)BorderType.EXTENDED, imageType);
        int numBands = imageType.getNumBands();
        this.background = new Planar(GrayF32.class, 1, 1, numBands);
        this._interpolationBG = FactoryInterpolation.createPixelMB((double)0.0, (double)255.0, (InterpolationType)interpType, (BorderType)BorderType.EXTENDED, (ImageType)ImageType.pl((int)numBands, GrayF32.class));
        this._interpolationBG.setImage(this.background);
        this.backgroundWrapper = FactoryGImageMultiBand.create((ImageType)ImageType.pl((int)numBands, GrayF32.class));
        this.backgroundWrapper.wrap(this.background);
        this.inputWrapper = FactoryGImageMultiBand.create(imageType);
        this.helpers = new GrowArray(() -> new Helper(imageType.numBands));
        this.helper = (Helper)this.helpers.grow();
    }

    @Override
    public void initialize(int backgroundWidth, int backgroundHeight, Motion homeToWorld) {
        this.background.reshape(backgroundWidth, backgroundHeight);
        GImageMiscOps.fill(this.background, (double)3.4028234663852886E38);
        this.homeToWorld.setTo(homeToWorld);
        this.homeToWorld.invert(this.worldToHome);
        this.backgroundWidth = backgroundWidth;
        this.backgroundHeight = backgroundHeight;
    }

    @Override
    public void reset() {
        GImageMiscOps.fill(this.background, (double)3.4028234663852886E38);
    }

    @Override
    protected void updateBackground(int x0, int y0, int x1, int y1, Planar<T> frame) {
        int idx0 = y0;
        int idx1 = y1;
        this.helper.updateBackground(x0, idx0, x1, idx1, frame);
    }

    @Override
    protected void _segment(Motion currentToWorld, Planar<T> frame, GrayU8 segmented) {
        this.inputWrapper.wrap(frame);
        boolean idx0 = false;
        int idx1 = frame.height;
        this.helper.segment(0, idx1, currentToWorld, frame, segmented);
    }

    public Planar<GrayF32> getBackground() {
        return this.background;
    }

    private class Helper {
        private final float[] valueInput;
        private final float[] valueBG;
        private final Point2D_F32 pixel = new Point2D_F32();
        private final Point2Transform2Model_F32<Motion> transform;
        private final InterpolatePixelMB<Planar<T>> interpolationInput;
        private final InterpolatePixelMB<Planar<GrayF32>> interpolationBG;

        public Helper(int numBands) {
            this.valueInput = new float[numBands];
            this.valueBG = new float[2 * numBands];
            this.transform = (Point2Transform2Model_F32)BackgroundMovingBasic_PL.this._transform.copyConcurrent();
            this.interpolationInput = BackgroundMovingBasic_PL.this._interpolationInput.copy();
            this.interpolationBG = BackgroundMovingBasic_PL.this._interpolationBG.copy();
            this.interpolationBG.setImage(BackgroundMovingBasic_PL.this.background);
        }

        public void updateBackground(int x0, int y0, int x1, int y1, Planar<T> frame) {
            this.interpolationInput.setImage(frame);
            int numBands = frame.getNumBands();
            float minusLearn = 1.0f - BackgroundMovingBasic_PL.this.learnRate;
            this.transform.setModel((Object)BackgroundMovingBasic_PL.this.worldToCurrent);
            for (int y = y0; y < y1; ++y) {
                int indexBG = BackgroundMovingBasic_PL.this.background.startIndex + y * BackgroundMovingBasic_PL.this.background.stride + x0;
                int x = x0;
                while (x < x1) {
                    this.transform.compute((float)x, (float)y, this.pixel);
                    if (this.pixel.x >= 0.0f && this.pixel.x < (float)frame.width && this.pixel.y >= 0.0f && this.pixel.y < (float)frame.height) {
                        this.interpolationInput.get(this.pixel.x, this.pixel.y, this.valueInput);
                        BackgroundMovingBasic_PL.this.backgroundWrapper.getF(indexBG, this.valueBG);
                        for (int band = 0; band < numBands; ++band) {
                            float value = this.valueInput[band];
                            float bg = this.valueBG[band];
                            this.valueBG[band] = bg == Float.MAX_VALUE ? value : minusLearn * bg + BackgroundMovingBasic_PL.this.learnRate * value;
                        }
                        BackgroundMovingBasic_PL.this.backgroundWrapper.setF(indexBG, this.valueBG);
                    }
                    ++x;
                    ++indexBG;
                }
            }
        }

        protected void segment(int y0, int y1, Motion currentToWorld, Planar<T> frame, GrayU8 segmented) {
            int numBands = BackgroundMovingBasic_PL.this.background.getNumBands();
            float thresholdSq = (float)numBands * BackgroundMovingBasic_PL.this.threshold * BackgroundMovingBasic_PL.this.threshold;
            this.transform.setModel(currentToWorld);
            for (int y = y0; y < y1; ++y) {
                int indexFrame = frame.startIndex + y * frame.stride;
                int indexSegmented = segmented.startIndex + y * segmented.stride;
                int x = 0;
                while (x < frame.width) {
                    block6: {
                        this.transform.compute((float)x, (float)y, this.pixel);
                        if (this.pixel.x >= 0.0f && this.pixel.x < (float)BackgroundMovingBasic_PL.this.background.width && this.pixel.y >= 0.0f && this.pixel.y < (float)BackgroundMovingBasic_PL.this.background.height) {
                            this.interpolationBG.get(this.pixel.x, this.pixel.y, this.valueBG);
                            BackgroundMovingBasic_PL.this.inputWrapper.getF(indexFrame, this.valueInput);
                            double sumErrorSq = 0.0;
                            for (int band = 0; band < numBands; ++band) {
                                float bg = this.valueBG[band];
                                float pixelFrame = this.valueInput[band];
                                if (bg == Float.MAX_VALUE) {
                                    segmented.data[indexSegmented] = BackgroundMovingBasic_PL.this.unknownValue;
                                    break block6;
                                }
                                float diff = bg - pixelFrame;
                                sumErrorSq += (double)(diff * diff);
                            }
                            segmented.data[indexSegmented] = (byte)(!(sumErrorSq <= (double)thresholdSq) ? 1 : 0);
                        } else {
                            segmented.data[indexSegmented] = BackgroundMovingBasic_PL.this.unknownValue;
                        }
                    }
                    ++x;
                    ++indexFrame;
                    ++indexSegmented;
                }
            }
        }
    }
}

