/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detdesc;

import boofcv.alg.feature.describe.DescribePointSift;
import boofcv.alg.feature.detdesc.CompleteSift;
import boofcv.alg.feature.detect.interest.SiftDetector;
import boofcv.alg.feature.detect.interest.SiftScaleSpace;
import boofcv.alg.feature.orientation.OrientationHistogramSift;
import boofcv.concurrency.BoofConcurrency;
import boofcv.misc.BoofLambdas;
import boofcv.struct.feature.ScalePoint;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.GrayF32;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F64;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastArray;
import pabeles.concurrency.GrowArray;

public class CompleteSift_MT
extends CompleteSift {
    public int minimumDetectionsThread = 50;
    GrowArray<ThreadHelper> helpers;
    FastArray<TupleDesc_F64> combinedFeatures = new FastArray(TupleDesc_F64.class);
    int dof = this.describe.getDescriptorLength();

    public CompleteSift_MT(SiftScaleSpace scaleSpace, SiftDetector detector, BoofLambdas.Factory<OrientationHistogramSift<GrayF32>> factoryOrientation, BoofLambdas.Factory<DescribePointSift<GrayF32>> factoryDescribe) {
        super(scaleSpace, detector, (OrientationHistogramSift)factoryOrientation.newInstance(), (DescribePointSift)factoryDescribe.newInstance());
        this.helpers = new GrowArray(() -> new ThreadHelper((OrientationHistogramSift)factoryOrientation.newInstance(), (DescribePointSift)factoryDescribe.newInstance()));
    }

    @Override
    public void process(GrayF32 input) {
        this.combinedFeatures.reset();
        super.process(input);
    }

    @Override
    protected void describeDetections(List<SiftDetector.SiftPoint> detections) {
        if (this.minimumDetectionsThread >= detections.size()) {
            super.describeDetections(detections);
        }
        BoofConcurrency.loopBlocks((int)0, (int)detections.size(), this.helpers, (helper, idx0, idx1) -> {
            OrientationHistogramSift<GrayF32> orientation = helper.orientation;
            DescribePointSift<GrayF32> describe = helper.describe;
            helper.reset();
            for (int detIdx = idx0; detIdx < idx1; ++detIdx) {
                SiftDetector.SiftPoint p = (SiftDetector.SiftPoint)detections.get(detIdx);
                GrayF32 derivX = this.gradient.getDerivX(p.octaveIdx, (byte)(p.scaleIdx - 1));
                GrayF32 derivY = this.gradient.getDerivY(p.octaveIdx, (byte)(p.scaleIdx - 1));
                orientation.setImageGradient(derivX, derivY);
                describe.setImageGradient(derivX, derivY);
                double pixelScaleToInput = this.scaleSpace.pixelScaleCurrentToInput(p.octaveIdx);
                double localX = p.pixel.x / pixelScaleToInput;
                double localY = p.pixel.y / pixelScaleToInput;
                double localSigma = p.scale / pixelScaleToInput;
                orientation.process(localX, localY, localSigma);
                DogArray_F64 angles = orientation.getOrientations();
                for (int angleIdx = 0; angleIdx < angles.size; ++angleIdx) {
                    describe.process(localX, localY, localSigma, angles.get(angleIdx), (TupleDesc_F64)helper.features.grow());
                    helper.orientations.add(angles.get(angleIdx));
                    helper.locations.add((Object)p);
                }
            }
        });
        for (int i = 0; i < this.helpers.size(); ++i) {
            ThreadHelper helper2 = (ThreadHelper)this.helpers.get(i);
            this.locations.addAll(helper2.locations);
            this.combinedFeatures.addAll(helper2.features);
            this.orientations.addAll(helper2.orientations);
        }
    }

    @Override
    public FastAccess<TupleDesc_F64> getDescriptions() {
        return this.combinedFeatures;
    }

    private class ThreadHelper {
        public final OrientationHistogramSift<GrayF32> orientation;
        public final DescribePointSift<GrayF32> describe;
        DogArray<TupleDesc_F64> features = new DogArray(() -> new TupleDesc_F64(CompleteSift_MT.this.dof));
        FastArray<ScalePoint> locations = new FastArray(ScalePoint.class);
        DogArray_F64 orientations = new DogArray_F64();

        public ThreadHelper(OrientationHistogramSift<GrayF32> orientation, DescribePointSift<GrayF32> describe) {
            this.orientation = orientation;
            this.describe = describe;
        }

        public void reset() {
            this.features.reset();
            this.locations.reset();
            this.orientations.reset();
        }
    }
}

