/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.interest;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.abst.filter.derivative.ImageHessian;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class EasyGeneralFeatureDetector<T extends ImageGray<T>, D extends ImageGray<D>> {
    protected GeneralFeatureDetector<T, D> detector;
    @Nullable
    protected ImageGradient<T, D> gradient;
    @Nullable
    protected ImageHessian<D> hessian;
    protected D derivX;
    protected D derivY;
    protected D derivXX;
    protected D derivYY;
    protected D derivXY;

    public EasyGeneralFeatureDetector(GeneralFeatureDetector<T, D> detector, @Nullable Class<T> imageType, @Nullable Class<D> derivType) {
        Class<T> im;
        this.detector = detector;
        if (imageType == null) {
            imageType = detector.getImageType();
        }
        if (derivType == null) {
            derivType = detector.getDerivType();
        }
        if (derivType == null) {
            im = Objects.requireNonNull(imageType, "Must specify image type since detector doesn't");
            derivType = GImageDerivativeOps.getDerivativeType(im);
        }
        if (detector.getRequiresGradient() || detector.getRequiresHessian()) {
            im = Objects.requireNonNull(imageType, "Must specify image type since detector doesn't");
            this.gradient = FactoryDerivative.sobel(im, (Class)derivType);
        }
        if (detector.getRequiresHessian()) {
            this.hessian = FactoryDerivative.hessianSobel((Class)derivType);
        }
        this.declareDerivativeImages(this.gradient, this.hessian, derivType);
    }

    public EasyGeneralFeatureDetector(GeneralFeatureDetector<T, D> detector, @Nullable ImageGradient<T, D> gradient, @Nullable ImageHessian<D> hessian, Class<D> derivType) {
        this.detector = detector;
        this.gradient = gradient;
        this.hessian = hessian;
        this.declareDerivativeImages(gradient, hessian, derivType);
    }

    private void declareDerivativeImages(@Nullable ImageGradient<T, D> gradient, @Nullable ImageHessian<D> hessian, Class<D> derivType) {
        if (gradient != null || hessian != null) {
            this.derivX = GeneralizedImageOps.createSingleBand(derivType, (int)1, (int)1);
            this.derivY = GeneralizedImageOps.createSingleBand(derivType, (int)1, (int)1);
        }
        if (hessian != null) {
            this.derivXX = GeneralizedImageOps.createSingleBand(derivType, (int)1, (int)1);
            this.derivYY = GeneralizedImageOps.createSingleBand(derivType, (int)1, (int)1);
            this.derivXY = GeneralizedImageOps.createSingleBand(derivType, (int)1, (int)1);
        }
    }

    public void detect(T input, @Nullable QueueCorner exclude) {
        this.initializeDerivatives(input);
        if (this.detector.getRequiresGradient() || this.detector.getRequiresHessian()) {
            Objects.requireNonNull(this.gradient).process(input, this.derivX, this.derivY);
        }
        if (this.detector.getRequiresHessian()) {
            Objects.requireNonNull(this.hessian).process(this.derivX, this.derivY, this.derivXX, this.derivYY, this.derivXY);
        }
        this.detector.setExclude(exclude);
        this.detector.process(input, this.derivX, this.derivY, this.derivXX, this.derivYY, this.derivXY);
    }

    private void initializeDerivatives(T input) {
        if (this.detector.getRequiresGradient() || this.detector.getRequiresHessian()) {
            this.derivX.reshape(((ImageGray)input).width, ((ImageGray)input).height);
            this.derivY.reshape(((ImageGray)input).width, ((ImageGray)input).height);
        }
        if (this.detector.getRequiresHessian()) {
            this.derivXX.reshape(((ImageGray)input).width, ((ImageGray)input).height);
            this.derivYY.reshape(((ImageGray)input).width, ((ImageGray)input).height);
            this.derivXY.reshape(((ImageGray)input).width, ((ImageGray)input).height);
        }
    }

    public GeneralFeatureDetector<T, D> getDetector() {
        return this.detector;
    }

    public QueueCorner getMaximums() {
        return this.detector.getMaximums();
    }

    public QueueCorner getMinimums() {
        return this.detector.getMinimums();
    }

    public ImageType<T> getInputType() {
        if (this.detector.getRequiresGradient() || this.detector.getRequiresHessian()) {
            return Objects.requireNonNull(this.gradient).getInputType();
        }
        return ImageType.single(Objects.requireNonNull(this.detector.getImageType()));
    }
}

