/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.detect.interest;

import boofcv.abst.feature.detect.extract.NonMaxSuppression;
import boofcv.abst.feature.detect.intensity.GeneralFeatureIntensity;
import boofcv.abst.feature.detect.intensity.WrapperFastCornerIntensity;
import boofcv.abst.feature.detect.intensity.WrapperGradientCornerIntensity;
import boofcv.abst.feature.detect.intensity.WrapperKitRosCornerIntensity;
import boofcv.abst.feature.detect.intensity.WrapperMedianCornerIntensity;
import boofcv.abst.feature.detect.interest.ConfigFastCorner;
import boofcv.abst.feature.detect.interest.ConfigGeneralDetector;
import boofcv.abst.feature.detect.interest.ConfigHarrisCorner;
import boofcv.abst.feature.detect.interest.ConfigPointDetector;
import boofcv.abst.feature.detect.interest.ConfigShiTomasi;
import boofcv.abst.filter.blur.BlurStorageFilter;
import boofcv.alg.feature.detect.intensity.FastCornerDetector;
import boofcv.alg.feature.detect.intensity.GradientCornerIntensity;
import boofcv.alg.feature.detect.intensity.HessianBlobIntensity;
import boofcv.alg.feature.detect.interest.GeneralFeatureDetector;
import boofcv.alg.feature.detect.selector.FeatureSelectLimitIntensity;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.factory.feature.detect.extract.FactoryFeatureExtractor;
import boofcv.factory.feature.detect.intensity.FactoryIntensityPoint;
import boofcv.factory.feature.detect.intensity.FactoryIntensityPointAlg;
import boofcv.factory.feature.detect.selector.FactorySelectLimit;
import boofcv.factory.filter.blur.FactoryBlurFilter;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_I16;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class FactoryDetectPoint {
    public static <T extends ImageGray<T>, D extends ImageGray<D>> GeneralFeatureDetector<T, D> create(ConfigPointDetector config, @Nullable Class<T> imageType, @Nullable Class<D> derivType) {
        GeneralFeatureDetector<T, D> generalFeatureDetector;
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(Objects.requireNonNull(imageType));
        }
        config.general.detectMaximums = true;
        config.general.detectMinimums = false;
        switch (config.type) {
            case FAST: 
            case LAPLACIAN: {
                config.general.detectMinimums = true;
                break;
            }
        }
        switch (config.type) {
            case HARRIS: {
                generalFeatureDetector = FactoryDetectPoint.createHarris(config.general, config.harris, Objects.requireNonNull(derivType));
                break;
            }
            case SHI_TOMASI: {
                generalFeatureDetector = FactoryDetectPoint.createShiTomasi(config.general, config.shiTomasi, derivType);
                break;
            }
            case FAST: {
                generalFeatureDetector = FactoryDetectPoint.createFast(config.general, config.fast, Objects.requireNonNull(imageType));
                break;
            }
            case KIT_ROS: {
                generalFeatureDetector = FactoryDetectPoint.createKitRos(config.general, Objects.requireNonNull(derivType));
                break;
            }
            case MEDIAN: {
                generalFeatureDetector = FactoryDetectPoint.createMedian(config.general, Objects.requireNonNull(imageType));
                break;
            }
            case DETERMINANT: {
                generalFeatureDetector = FactoryDetectPoint.createHessianDirect(HessianBlobIntensity.Type.DETERMINANT, config.general, Objects.requireNonNull(imageType));
                break;
            }
            case LAPLACIAN: {
                generalFeatureDetector = FactoryDetectPoint.createHessianDirect(HessianBlobIntensity.Type.TRACE, config.general, Objects.requireNonNull(imageType));
                break;
            }
            case DETERMINANT_H: {
                generalFeatureDetector = FactoryDetectPoint.createHessianDeriv(config.general, HessianBlobIntensity.Type.DETERMINANT, Objects.requireNonNull(derivType));
                break;
            }
            case LAPLACIAN_H: {
                generalFeatureDetector = FactoryDetectPoint.createHessianDeriv(config.general, HessianBlobIntensity.Type.TRACE, Objects.requireNonNull(derivType));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + config.type);
            }
        }
        return generalFeatureDetector;
    }

    public static <T extends ImageGray<T>, D extends ImageGray<D>> GeneralFeatureDetector<T, D> createHarris(@Nullable ConfigGeneralDetector configDetector, @Nullable ConfigHarrisCorner configCorner, Class<D> derivType) {
        if (configDetector == null) {
            configDetector = new ConfigGeneralDetector();
        }
        if (configCorner == null) {
            configCorner = new ConfigHarrisCorner();
            configCorner.radius = configDetector.radius;
        }
        GradientCornerIntensity<D> cornerIntensity = FactoryIntensityPointAlg.harris(configCorner.radius, (float)configCorner.kappa, configCorner.weighted, derivType);
        return FactoryDetectPoint.createGeneral(cornerIntensity, configDetector);
    }

    public static <T extends ImageGray<T>, D extends ImageGray<D>> GeneralFeatureDetector<T, D> createShiTomasi(@Nullable ConfigGeneralDetector configDetector, @Nullable ConfigShiTomasi configCorner, Class<D> derivType) {
        if (configDetector == null) {
            configDetector = new ConfigGeneralDetector();
        }
        if (configCorner == null) {
            configCorner = new ConfigShiTomasi();
            configCorner.radius = configDetector.radius;
        }
        GradientCornerIntensity<D> cornerIntensity = FactoryIntensityPointAlg.shiTomasi(configCorner.radius, configCorner.weighted, derivType);
        return FactoryDetectPoint.createGeneral(cornerIntensity, configDetector);
    }

    public static <T extends ImageGray<T>, D extends ImageGray<D>> GeneralFeatureDetector<T, D> createKitRos(@Nullable ConfigGeneralDetector configDetector, Class<D> derivType) {
        if (configDetector == null) {
            configDetector = new ConfigGeneralDetector();
        }
        WrapperKitRosCornerIntensity intensity = new WrapperKitRosCornerIntensity(derivType);
        return FactoryDetectPoint.createGeneral(intensity, configDetector);
    }

    public static <T extends ImageGray<T>, D extends ImageGray<D>> GeneralFeatureDetector<T, D> createFast(ConfigGeneralDetector configDetector, @Nullable ConfigFastCorner configFast, Class<T> imageType) {
        if (configFast == null) {
            configFast = new ConfigFastCorner();
        }
        configFast.checkValidity();
        FastCornerDetector<T> alg = FactoryIntensityPointAlg.fast(configFast.pixelTol, configFast.minContinuous, imageType);
        WrapperFastCornerIntensity intensity = new WrapperFastCornerIntensity(alg);
        return FactoryDetectPoint.createGeneral(intensity, configDetector);
    }

    public static <T extends ImageGray<T>, D extends ImageGray<D>> GeneralFeatureDetector<T, D> createMedian(@Nullable ConfigGeneralDetector configDetector, Class<T> imageType) {
        if (configDetector == null) {
            configDetector = new ConfigGeneralDetector();
        }
        BlurStorageFilter medianFilter = FactoryBlurFilter.median((ImageType)ImageType.single(imageType), (int)configDetector.radius);
        WrapperMedianCornerIntensity intensity = new WrapperMedianCornerIntensity(medianFilter);
        return FactoryDetectPoint.createGeneral(intensity, configDetector);
    }

    public static <T extends ImageGray<T>, D extends ImageGray<D>> GeneralFeatureDetector<T, D> createHessianDeriv(@Nullable ConfigGeneralDetector configDetector, HessianBlobIntensity.Type type, Class<D> derivType) {
        if (configDetector == null) {
            configDetector = new ConfigGeneralDetector();
        }
        GeneralFeatureIntensity intensity = FactoryIntensityPoint.hessian(type, derivType);
        return FactoryDetectPoint.createGeneral(intensity, configDetector);
    }

    public static <T extends ImageGray<T>, D extends ImageGray<D>> GeneralFeatureDetector<T, D> createHessianDirect(HessianBlobIntensity.Type type, @Nullable ConfigGeneralDetector configDetector, Class<T> imageType) {
        GeneralFeatureIntensity<T, Object> generalFeatureIntensity;
        if (configDetector == null) {
            configDetector = new ConfigGeneralDetector();
        }
        switch (type) {
            case DETERMINANT: {
                generalFeatureIntensity = FactoryIntensityPoint.hessianDet(imageType);
                break;
            }
            case TRACE: {
                generalFeatureIntensity = FactoryIntensityPoint.laplacian(imageType);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type");
            }
        }
        GeneralFeatureIntensity<T, Object> intensity = generalFeatureIntensity;
        return FactoryDetectPoint.createGeneral(intensity, configDetector);
    }

    public static <T extends ImageGray<T>, D extends ImageGray<D>> GeneralFeatureDetector<T, D> createGeneral(GradientCornerIntensity<D> cornerIntensity, ConfigGeneralDetector config) {
        WrapperGradientCornerIntensity intensity = new WrapperGradientCornerIntensity(cornerIntensity);
        return FactoryDetectPoint.createGeneral(intensity, config);
    }

    public static <T extends ImageGray<T>, D extends ImageGray<D>> GeneralFeatureDetector<T, D> createGeneral(GeneralFeatureIntensity<T, D> intensity, ConfigGeneralDetector config) {
        ConfigGeneralDetector foo = new ConfigGeneralDetector();
        foo.setTo(config);
        config = foo;
        config.ignoreBorder += config.radius;
        NonMaxSuppression extractorMin = null;
        NonMaxSuppression extractorMax = null;
        if (intensity.localMinimums()) {
            config.detectMinimums = true;
            config.detectMaximums = false;
            extractorMin = FactoryFeatureExtractor.nonmax(config);
        }
        if (intensity.localMaximums()) {
            config.detectMinimums = false;
            config.detectMaximums = true;
            extractorMax = FactoryFeatureExtractor.nonmax(config);
        }
        FeatureSelectLimitIntensity<Point2D_I16> selector = FactorySelectLimit.intensity(config.selector, Point2D_I16.class);
        GeneralFeatureDetector<T, D> det = new GeneralFeatureDetector<T, D>(intensity, extractorMin, extractorMax, selector);
        det.setFeatureLimit(config.maxFeatures);
        return det;
    }
}

