/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.feature;

public class AssociatedIndex {
    public int src;
    public int dst;
    public double fitScore;

    public AssociatedIndex(AssociatedIndex original) {
        this.setTo(original);
    }

    public AssociatedIndex(int src, int dst, double fitScore) {
        this.src = src;
        this.dst = dst;
        this.fitScore = fitScore;
    }

    public AssociatedIndex(int src, int dst) {
        this.src = src;
        this.dst = dst;
        this.fitScore = 0.0;
    }

    public AssociatedIndex() {
    }

    public void setTo(int src, int dst, double fitScore) {
        this.src = src;
        this.dst = dst;
        this.fitScore = fitScore;
    }

    public void setTo(int src, int dst) {
        this.src = src;
        this.dst = dst;
        this.fitScore = 0.0;
    }

    public void setTo(AssociatedIndex a) {
        this.src = a.src;
        this.dst = a.dst;
        this.fitScore = a.fitScore;
    }

    public boolean isIdentical(AssociatedIndex o) {
        return this.src == o.src && this.dst == o.dst && this.fitScore == o.fitScore;
    }

    public AssociatedIndex copy() {
        return new AssociatedIndex(this);
    }

    public int getSrc() {
        return this.src;
    }

    public int getDst() {
        return this.dst;
    }

    public double getFitScore() {
        return this.fitScore;
    }

    public void setSrc(int src) {
        this.src = src;
    }

    public void setDst(int dst) {
        this.dst = dst;
    }

    public void setFitScore(double fitScore) {
        this.fitScore = fitScore;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssociatedIndex)) {
            return false;
        }
        AssociatedIndex other = (AssociatedIndex)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSrc() != other.getSrc()) {
            return false;
        }
        if (this.getDst() != other.getDst()) {
            return false;
        }
        return Double.compare(this.getFitScore(), other.getFitScore()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssociatedIndex;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSrc();
        result = result * 59 + this.getDst();
        long $fitScore = Double.doubleToLongBits(this.getFitScore());
        result = result * 59 + (int)($fitScore >>> 32 ^ $fitScore);
        return result;
    }

    public String toString() {
        return "AssociatedIndex(src=" + this.getSrc() + ", dst=" + this.getDst() + ", fitScore=" + this.getFitScore() + ")";
    }
}

