/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.feature;

import boofcv.misc.BoofLambdas;
import boofcv.struct.PackedArray;
import boofcv.struct.feature.PackedTupleArray;
import boofcv.struct.feature.TupleDesc_B;
import org.ddogleg.struct.DogArray_I32;

public class PackedTupleArray_B
implements PackedTupleArray<TupleDesc_B> {
    public final int dof;
    public final DogArray_I32 array;
    public final TupleDesc_B temp;
    protected int numElements;
    protected final int numInts;

    public PackedTupleArray_B(int dof) {
        this.dof = dof;
        this.temp = new TupleDesc_B(dof);
        this.numInts = this.temp.data.length;
        this.array = new DogArray_I32();
        this.array.resize(0);
    }

    public void reset() {
        this.numElements = 0;
        this.array.reset();
    }

    public void reserve(int numTuples) {
        this.array.reserve(numTuples * this.numInts);
    }

    public void append(TupleDesc_B element) {
        this.array.addAll(element.data, 0, this.numInts);
        ++this.numElements;
    }

    public void set(int index, TupleDesc_B element) {
        System.arraycopy(element.data, 0, this.array.data, index * this.numInts, this.numInts);
    }

    public TupleDesc_B getTemp(int index) {
        System.arraycopy(this.array.data, index * this.numInts, this.temp.data, 0, this.numInts);
        return this.temp;
    }

    public void getCopy(int index, TupleDesc_B dst) {
        System.arraycopy(this.array.data, index * this.numInts, dst.data, 0, this.numInts);
    }

    public void copy(TupleDesc_B src, TupleDesc_B dst) {
        System.arraycopy(src.data, 0, dst.data, 0, this.numInts);
    }

    public int size() {
        return this.numElements;
    }

    public Class<TupleDesc_B> getElementType() {
        return TupleDesc_B.class;
    }

    public void forIdx(int idx0, int idx1, BoofLambdas.ProcessIndex<TupleDesc_B> op) {
        int pointIndex = idx0;
        idx1 *= this.numInts;
        for (int i = idx0 *= this.numInts; i < idx1; i += this.numInts) {
            System.arraycopy(this.array.data, i, this.temp.data, 0, this.numInts);
            op.process(pointIndex++, (Object)this.temp);
        }
    }

    public boolean isEquals(PackedArray<TupleDesc_B> other) {
        return this.array.isEquals(((PackedTupleArray_B)other).array);
    }

    @Override
    public int getDOF() {
        return this.dof;
    }
}

