/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.feature;

import boofcv.struct.feature.PackedTupleArray;
import boofcv.struct.feature.TupleDesc_S8;
import georegression.struct.packed.PackedArray;
import org.ddogleg.struct.DogArray_I8;

public class PackedTupleArray_S8
implements PackedTupleArray<TupleDesc_S8> {
    public final int dof;
    public final DogArray_I8 array;
    public final TupleDesc_S8 temp;
    protected int numElements;

    public PackedTupleArray_S8(int dof) {
        this.dof = dof;
        this.temp = new TupleDesc_S8(dof);
        this.array = new DogArray_I8();
        this.array.resize(0);
    }

    public void removeSwap(int index) {
        int where = (index + 1) * this.dof - 1;
        for (int i = 0; i < this.dof; ++i) {
            this.array.removeSwap(where--);
        }
    }

    public PackedTupleArray_S8 reset() {
        this.numElements = 0;
        this.array.reset();
        return this;
    }

    public PackedTupleArray_S8 reserve(int numTuples) {
        this.array.reserve(numTuples * this.dof);
        return this;
    }

    public void append(TupleDesc_S8 element) {
        this.array.addAll(element.data, 0, this.dof);
        ++this.numElements;
    }

    public void set(int index, TupleDesc_S8 element) {
        System.arraycopy(element.data, 0, this.array.data, index * this.dof, this.dof);
    }

    public TupleDesc_S8 getTemp(int index) {
        System.arraycopy(this.array.data, index * this.dof, this.temp.data, 0, this.dof);
        return this.temp;
    }

    public void getCopy(int index, TupleDesc_S8 dst) {
        System.arraycopy(this.array.data, index * this.dof, dst.data, 0, this.dof);
    }

    public void copy(TupleDesc_S8 src, TupleDesc_S8 dst) {
        System.arraycopy(src.data, 0, dst.data, 0, this.dof);
    }

    public int size() {
        return this.numElements;
    }

    public Class<TupleDesc_S8> getElementType() {
        return TupleDesc_S8.class;
    }

    public void forIdx(int idx0, int idx1, PackedArray.ProcessIndex<TupleDesc_S8> op) {
        int pointIndex = idx0;
        idx1 *= this.dof;
        for (int i = idx0 *= this.dof; i < idx1; i += this.dof) {
            System.arraycopy(this.array.data, i, this.temp.data, 0, this.dof);
            op.process(pointIndex++, (Object)this.temp);
        }
    }

    public boolean isEquals(PackedArray<TupleDesc_S8> other) {
        return this.array.isEquals(((PackedTupleArray_S8)other).array);
    }

    @Override
    public int getDOF() {
        return this.dof;
    }
}

