/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.feature;

import boofcv.struct.feature.PackedTupleArray;
import boofcv.struct.feature.TupleDesc_F32;
import georegression.struct.packed.PackedArray;
import org.ddogleg.struct.BigDogArray_F32;
import org.ddogleg.struct.BigDogGrowth;

public class PackedTupleBigArray_F32
implements PackedTupleArray<TupleDesc_F32> {
    public final int dof;
    public final BigDogArray_F32 array;
    public final TupleDesc_F32 temp;
    protected int numElements;

    public PackedTupleBigArray_F32(int dof) {
        this.dof = dof;
        this.temp = new TupleDesc_F32(dof);
        this.array = new BigDogArray_F32(dof, dof * 65536, BigDogGrowth.GROW_FIRST);
        this.array.resize(0);
    }

    public void removeSwap(int index) {
        int where = (index + 1) * this.dof - 1;
        for (int i = 0; i < this.dof; ++i) {
            this.array.removeSwap(where--);
        }
    }

    public PackedTupleBigArray_F32 reset() {
        this.numElements = 0;
        this.array.reset();
        return this;
    }

    public PackedTupleBigArray_F32 reserve(int numTuples) {
        this.array.reserve(numTuples * this.dof);
        return this;
    }

    public void append(TupleDesc_F32 element) {
        this.array.append((Object)element.data, 0, this.dof);
        ++this.numElements;
    }

    public void set(int index, TupleDesc_F32 element) {
        this.array.setArray((long)index * (long)this.dof, (Object)element.data, 0, this.dof);
    }

    public TupleDesc_F32 getTemp(int index) {
        this.array.getArray(index * this.dof, this.temp.data, 0, this.dof);
        return this.temp;
    }

    public void getCopy(int index, TupleDesc_F32 dst) {
        this.array.getArray(index * this.dof, dst.data, 0, this.dof);
    }

    public void copy(TupleDesc_F32 src, TupleDesc_F32 dst) {
        System.arraycopy(src.data, 0, dst.data, 0, this.dof);
    }

    public int size() {
        return this.numElements;
    }

    public Class<TupleDesc_F32> getElementType() {
        return TupleDesc_F32.class;
    }

    public void forIdx(int idx0, int idx1, PackedArray.ProcessIndex<TupleDesc_F32> op) {
        this.array.processByBlock(idx0 * this.dof, idx1 * this.dof, (array, arrayIdx0, arrayIdx1, offset) -> {
            int pointIndex = idx0 + offset / this.dof;
            for (int i = arrayIdx0; i < arrayIdx1; i += this.dof) {
                System.arraycopy(array, i, this.temp.data, 0, this.dof);
                op.process(pointIndex++, (Object)this.temp);
            }
        });
    }

    public boolean isEquals(PackedArray<TupleDesc_F32> other) {
        return this.array.isEquivalent(((PackedTupleBigArray_F32)other).array, 0.0f);
    }

    @Override
    public int getDOF() {
        return this.dof;
    }
}

