/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.ffmpeg;

import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.SimpleImageSequence;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.bytedeco.copiedstuff.FFmpegFrameGrabber;
import org.bytedeco.copiedstuff.Frame;
import org.bytedeco.copiedstuff.FrameGrabber;
import org.bytedeco.copiedstuff.Java2DFrameConverter;
import org.bytedeco.javacpp.avutil;

public class FfmpegVideoImageSequence<T extends ImageBase<T>>
implements SimpleImageSequence<T> {
    String filename;
    FFmpegFrameGrabber frameGrabber;
    ImageType<T> imageType;
    Java2DFrameConverter converter;
    boolean finished = false;
    BufferedImage current;
    BufferedImage next;
    T currentBoof;
    int frameNumber;

    public FfmpegVideoImageSequence(String filename, ImageType<T> imageType) {
        avutil.av_log_set_level((int)16);
        this.filename = filename;
        this.imageType = imageType;
        this.converter = new Java2DFrameConverter();
        this.reset();
        if (this.finished) {
            throw new RuntimeException("FFMPEG failed to open file");
        }
    }

    public int getNextWidth() {
        return this.next.getWidth();
    }

    public int getNextHeight() {
        return this.next.getHeight();
    }

    public boolean hasNext() {
        return !this.finished;
    }

    public T next() {
        if (this.finished) {
            return null;
        }
        this.current.createGraphics().drawImage((Image)this.next, 0, 0, null);
        try {
            this.next = this.converter.convert(this.frameGrabber.grab());
            ++this.frameNumber;
        }
        catch (FrameGrabber.Exception e) {
            this.finished = true;
        }
        if (this.frameNumber >= this.frameGrabber.getLengthInFrames()) {
            this.finished = true;
        }
        ConvertBufferedImage.convertFrom((BufferedImage)this.current, this.currentBoof, (boolean)true);
        return this.currentBoof;
    }

    public <InternalImage> InternalImage getGuiImage() {
        return (InternalImage)this.current;
    }

    public void close() {
        try {
            this.frameGrabber.stop();
            this.finished = true;
        }
        catch (FrameGrabber.Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public void setLoop(boolean loop) {
    }

    public ImageType<T> getImageType() {
        return this.imageType;
    }

    public void reset() {
        this.frameGrabber = new FFmpegFrameGrabber(this.filename);
        try {
            this.frameNumber = 0;
            this.finished = false;
            this.frameGrabber.start();
        }
        catch (FrameGrabber.Exception e) {
            this.finished = true;
            return;
        }
        try {
            Frame frame = this.frameGrabber.grab();
            this.next = this.converter.convert(frame);
            this.current = new BufferedImage(this.next.getWidth(), this.next.getHeight(), this.next.getType());
            this.currentBoof = this.imageType.createImage(this.next.getWidth(), this.next.getHeight());
        }
        catch (FrameGrabber.Exception e) {
            this.finished = true;
        }
    }
}

