/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.copiedstuff;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.bytedeco.copiedstuff.Frame;
import org.bytedeco.copiedstuff.FrameGrabber;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.avcodec;
import org.bytedeco.javacpp.avdevice;
import org.bytedeco.javacpp.avformat;
import org.bytedeco.javacpp.avutil;
import org.bytedeco.javacpp.swresample;
import org.bytedeco.javacpp.swscale;

public class FFmpegFrameGrabber
extends FrameGrabber {
    private static FrameGrabber.Exception loadingException = null;
    static HashMap<Pointer, InputStream> inputStreams;
    static ReadCallback readCallback;
    static SeekCallback seekCallback;
    private InputStream inputStream;
    private avformat.AVIOContext avio;
    private String filename;
    private avformat.AVFormatContext oc;
    private avformat.AVStream video_st;
    private avformat.AVStream audio_st;
    private avcodec.AVCodecContext video_c;
    private avcodec.AVCodecContext audio_c;
    private avutil.AVFrame picture;
    private avutil.AVFrame picture_rgb;
    private BytePointer[] image_ptr;
    private Buffer[] image_buf;
    private avutil.AVFrame samples_frame;
    private BytePointer[] samples_ptr;
    private Buffer[] samples_buf;
    private avcodec.AVPacket pkt;
    private avcodec.AVPacket pkt2;
    private int sizeof_pkt;
    private int[] got_frame;
    private swscale.SwsContext img_convert_ctx;
    private boolean frameGrabbed;
    private Frame frame;

    public static String[] getDeviceDescriptions() throws FrameGrabber.Exception {
        FFmpegFrameGrabber.tryLoad();
        throw new UnsupportedOperationException("Device enumeration not support by FFmpeg.");
    }

    public static FFmpegFrameGrabber createDefault(File deviceFile) throws FrameGrabber.Exception {
        return new FFmpegFrameGrabber(deviceFile);
    }

    public static FFmpegFrameGrabber createDefault(String devicePath) throws FrameGrabber.Exception {
        return new FFmpegFrameGrabber(devicePath);
    }

    public static FFmpegFrameGrabber createDefault(int deviceNumber) throws FrameGrabber.Exception {
        throw new FrameGrabber.Exception(FFmpegFrameGrabber.class + " does not support device numbers.");
    }

    public static void tryLoad() throws FrameGrabber.Exception {
        if (loadingException != null) {
            throw loadingException;
        }
        try {
            Loader.load(avutil.class);
            Loader.load(swresample.class);
            Loader.load(avcodec.class);
            Loader.load(avformat.class);
            Loader.load(swscale.class);
            avcodec.avcodec_register_all();
            avformat.av_register_all();
            avformat.avformat_network_init();
            Loader.load(avdevice.class);
            avdevice.avdevice_register_all();
        }
        catch (Throwable t) {
            if (t instanceof FrameGrabber.Exception) {
                loadingException = (FrameGrabber.Exception)t;
                throw loadingException;
            }
            loadingException = new FrameGrabber.Exception("Failed to load " + FFmpegFrameGrabber.class, t);
            throw loadingException;
        }
    }

    public FFmpegFrameGrabber(File file) {
        this(file.getAbsolutePath());
    }

    public FFmpegFrameGrabber(String filename) {
        this.filename = filename;
    }

    public FFmpegFrameGrabber(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() throws FrameGrabber.Exception {
        Class<avcodec> clazz = avcodec.class;
        synchronized (avcodec.class) {
            this.releaseUnsafe();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void releaseUnsafe() throws FrameGrabber.Exception {
        if (this.pkt != null && this.pkt2 != null) {
            if (this.pkt2.size() > 0) {
                avcodec.av_packet_unref((avcodec.AVPacket)this.pkt);
            }
            this.pkt2 = null;
            this.pkt = null;
        }
        if (this.image_ptr != null) {
            for (int i = 0; i < this.image_ptr.length; ++i) {
                avutil.av_free((Pointer)this.image_ptr[i]);
            }
            this.image_ptr = null;
        }
        if (this.picture_rgb != null) {
            avutil.av_frame_free((avutil.AVFrame)this.picture_rgb);
            this.picture_rgb = null;
        }
        if (this.picture != null) {
            avutil.av_frame_free((avutil.AVFrame)this.picture);
            this.picture = null;
        }
        if (this.video_c != null) {
            avcodec.avcodec_free_context((avcodec.AVCodecContext)this.video_c);
            this.video_c = null;
        }
        if (this.samples_frame != null) {
            avutil.av_frame_free((avutil.AVFrame)this.samples_frame);
            this.samples_frame = null;
        }
        if (this.audio_c != null) {
            avcodec.avcodec_free_context((avcodec.AVCodecContext)this.audio_c);
            this.audio_c = null;
        }
        if (this.inputStream == null && this.oc != null && !this.oc.isNull()) {
            avformat.avformat_close_input((avformat.AVFormatContext)this.oc);
            this.oc = null;
        }
        if (this.img_convert_ctx != null) {
            swscale.sws_freeContext((swscale.SwsContext)this.img_convert_ctx);
            this.img_convert_ctx = null;
        }
        this.got_frame = null;
        this.frameGrabbed = false;
        this.frame = null;
        this.timestamp = 0L;
        this.frameNumber = 0;
        if (this.inputStream != null) {
            try {
                if (this.oc == null) {
                    this.inputStream.close();
                } else {
                    this.inputStream.reset();
                }
            }
            catch (IOException ex) {
                throw new FrameGrabber.Exception("Error on InputStream.close(): ", ex);
            }
            finally {
                inputStreams.remove(this.oc);
                if (this.avio != null) {
                    if (this.avio.buffer() != null) {
                        avutil.av_free((Pointer)this.avio.buffer());
                        this.avio.buffer(null);
                    }
                    avutil.av_free((Pointer)this.avio);
                    this.avio = null;
                }
                if (this.oc != null) {
                    avformat.avformat_free_context((avformat.AVFormatContext)this.oc);
                    this.oc = null;
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    @Override
    public double getGamma() {
        if (this.gamma == 0.0) {
            return 2.2;
        }
        return this.gamma;
    }

    @Override
    public String getFormat() {
        if (this.oc == null) {
            return super.getFormat();
        }
        return this.oc.iformat().name().getString();
    }

    @Override
    public int getImageWidth() {
        return this.imageWidth > 0 || this.video_c == null ? super.getImageWidth() : this.video_c.width();
    }

    @Override
    public int getImageHeight() {
        return this.imageHeight > 0 || this.video_c == null ? super.getImageHeight() : this.video_c.height();
    }

    @Override
    public int getAudioChannels() {
        return this.audio_c == null ? super.getAudioChannels() : this.audio_c.channels();
    }

    @Override
    public int getPixelFormat() {
        if (this.imageMode == FrameGrabber.ImageMode.COLOR || this.imageMode == FrameGrabber.ImageMode.GRAY) {
            if (this.pixelFormat == -1) {
                return this.imageMode == FrameGrabber.ImageMode.COLOR ? 3 : 8;
            }
            return this.pixelFormat;
        }
        if (this.video_c != null) {
            return this.video_c.pix_fmt();
        }
        return super.getPixelFormat();
    }

    @Override
    public int getVideoCodec() {
        return this.video_c == null ? super.getVideoCodec() : this.video_c.codec_id();
    }

    @Override
    public int getVideoBitrate() {
        return this.video_c == null ? super.getVideoBitrate() : (int)this.video_c.bit_rate();
    }

    @Override
    public double getAspectRatio() {
        if (this.video_st == null) {
            return super.getAspectRatio();
        }
        avutil.AVRational r = avformat.av_guess_sample_aspect_ratio((avformat.AVFormatContext)this.oc, (avformat.AVStream)this.video_st, (avutil.AVFrame)this.picture);
        double a = (double)r.num() / (double)r.den();
        return a == 0.0 ? 1.0 : a;
    }

    @Override
    public double getFrameRate() {
        if (this.video_st == null) {
            return super.getFrameRate();
        }
        avutil.AVRational r = this.video_st.avg_frame_rate();
        if (r.num() == 0 && r.den() == 0) {
            r = this.video_st.r_frame_rate();
        }
        return (double)r.num() / (double)r.den();
    }

    @Override
    public int getAudioCodec() {
        return this.audio_c == null ? super.getAudioCodec() : this.audio_c.codec_id();
    }

    @Override
    public int getAudioBitrate() {
        return this.audio_c == null ? super.getAudioBitrate() : (int)this.audio_c.bit_rate();
    }

    @Override
    public int getSampleFormat() {
        return this.audio_c == null ? super.getSampleFormat() : this.audio_c.sample_fmt();
    }

    @Override
    public int getSampleRate() {
        return this.audio_c == null ? super.getSampleRate() : this.audio_c.sample_rate();
    }

    @Override
    public String getMetadata(String key) {
        if (this.oc == null) {
            return super.getMetadata(key);
        }
        avutil.AVDictionaryEntry entry = avutil.av_dict_get((avutil.AVDictionary)this.oc.metadata(), (String)key, null, (int)0);
        return entry == null || entry.value() == null ? null : entry.value().getString();
    }

    @Override
    public String getVideoMetadata(String key) {
        if (this.video_st == null) {
            return super.getVideoMetadata(key);
        }
        avutil.AVDictionaryEntry entry = avutil.av_dict_get((avutil.AVDictionary)this.video_st.metadata(), (String)key, null, (int)0);
        return entry == null || entry.value() == null ? null : entry.value().getString();
    }

    @Override
    public String getAudioMetadata(String key) {
        if (this.audio_st == null) {
            return super.getAudioMetadata(key);
        }
        avutil.AVDictionaryEntry entry = avutil.av_dict_get((avutil.AVDictionary)this.audio_st.metadata(), (String)key, null, (int)0);
        return entry == null || entry.value() == null ? null : entry.value().getString();
    }

    @Override
    public void setFrameNumber(int frameNumber) throws FrameGrabber.Exception {
        this.setTimestamp(Math.round((double)(1000000L * (long)frameNumber) / this.getFrameRate()));
    }

    @Override
    public void setTimestamp(long timestamp) throws FrameGrabber.Exception {
        if (this.oc == null) {
            super.setTimestamp(timestamp);
        } else {
            int ret;
            timestamp = timestamp * 1000000L / 1000000L;
            if (this.oc.start_time() != avutil.AV_NOPTS_VALUE) {
                timestamp += this.oc.start_time();
            }
            if ((ret = avformat.avformat_seek_file((avformat.AVFormatContext)this.oc, (int)-1, (long)Long.MIN_VALUE, (long)timestamp, (long)Long.MAX_VALUE, (int)1)) < 0) {
                throw new FrameGrabber.Exception("avformat_seek_file() error " + ret + ": Could not seek file to timestamp " + timestamp + ".");
            }
            if (this.video_c != null) {
                avcodec.avcodec_flush_buffers((avcodec.AVCodecContext)this.video_c);
            }
            if (this.audio_c != null) {
                avcodec.avcodec_flush_buffers((avcodec.AVCodecContext)this.audio_c);
            }
            if (this.pkt2.size() > 0) {
                this.pkt2.size(0);
                avcodec.av_packet_unref((avcodec.AVPacket)this.pkt);
            }
            while (this.timestamp > timestamp + 1L && this.grabFrame(false, true, false, false) != null) {
            }
            while (this.timestamp < timestamp - 1L && this.grabFrame(false, true, false, false) != null) {
            }
            if (this.video_c != null) {
                this.frameGrabbed = true;
            }
        }
    }

    @Override
    public int getLengthInFrames() {
        return (int)((double)this.getLengthInTime() * this.getFrameRate() / 1000000.0);
    }

    @Override
    public long getLengthInTime() {
        return this.oc.duration() * 1000000L / 1000000L;
    }

    public avformat.AVFormatContext getFormatContext() {
        return this.oc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws FrameGrabber.Exception {
        Class<avcodec> clazz = avcodec.class;
        synchronized (avcodec.class) {
            this.startUnsafe();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void startUnsafe() throws FrameGrabber.Exception {
        int ret;
        this.img_convert_ctx = null;
        this.oc = new avformat.AVFormatContext(null);
        this.video_c = null;
        this.audio_c = null;
        this.pkt = new avcodec.AVPacket();
        this.pkt2 = new avcodec.AVPacket();
        this.sizeof_pkt = this.pkt.sizeof();
        this.got_frame = new int[1];
        this.frameGrabbed = false;
        this.frame = new Frame();
        this.timestamp = 0L;
        this.frameNumber = 0;
        this.pkt2.size(0);
        avformat.AVInputFormat f = null;
        if (this.format != null && this.format.length() > 0 && (f = avformat.av_find_input_format((String)this.format)) == null) {
            throw new FrameGrabber.Exception("av_find_input_format() error: Could not find input format \"" + this.format + "\".");
        }
        avutil.AVDictionary options = new avutil.AVDictionary(null);
        if (this.frameRate > 0.0) {
            avutil.AVRational r = avutil.av_d2q((double)this.frameRate, (int)1001000);
            avutil.av_dict_set((avutil.AVDictionary)options, (String)"framerate", (String)(r.num() + "/" + r.den()), (int)0);
        }
        if (this.pixelFormat >= 0) {
            avutil.av_dict_set((avutil.AVDictionary)options, (String)"pixel_format", (String)avutil.av_get_pix_fmt_name((int)this.pixelFormat).getString(), (int)0);
        } else if (this.imageMode != FrameGrabber.ImageMode.RAW) {
            avutil.av_dict_set((avutil.AVDictionary)options, (String)"pixel_format", (String)(this.imageMode == FrameGrabber.ImageMode.COLOR ? "bgr24" : "gray8"), (int)0);
        }
        if (this.imageWidth > 0 && this.imageHeight > 0) {
            avutil.av_dict_set((avutil.AVDictionary)options, (String)"video_size", (String)(this.imageWidth + "x" + this.imageHeight), (int)0);
        }
        if (this.sampleRate > 0) {
            avutil.av_dict_set((avutil.AVDictionary)options, (String)"sample_rate", (String)("" + this.sampleRate), (int)0);
        }
        if (this.audioChannels > 0) {
            avutil.av_dict_set((avutil.AVDictionary)options, (String)"channels", (String)("" + this.audioChannels), (int)0);
        }
        for (Map.Entry entry : this.options.entrySet()) {
            avutil.av_dict_set((avutil.AVDictionary)options, (String)((String)entry.getKey()), (String)((String)entry.getValue()), (int)0);
        }
        if (this.inputStream != null) {
            if (readCallback == null) {
                readCallback = new ReadCallback();
            }
            if (seekCallback == null) {
                seekCallback = new SeekCallback();
            }
            if (!this.inputStream.markSupported()) {
                this.inputStream = new BufferedInputStream(this.inputStream, 0x100000);
            }
            this.inputStream.mark(0x100000);
            this.oc = avformat.avformat_alloc_context();
            this.avio = avformat.avio_alloc_context((BytePointer)new BytePointer(avutil.av_malloc((long)4096L)), (int)4096, (int)0, (Pointer)this.oc, (avformat.Read_packet_Pointer_BytePointer_int)readCallback, null, (avformat.Seek_Pointer_long_int)seekCallback);
            this.oc.pb(this.avio);
            this.filename = this.inputStream.toString();
            inputStreams.put((Pointer)this.oc, this.inputStream);
        }
        if ((ret = avformat.avformat_open_input((avformat.AVFormatContext)this.oc, (String)this.filename, (avformat.AVInputFormat)f, (avutil.AVDictionary)options)) < 0) {
            avutil.av_dict_set((avutil.AVDictionary)options, (String)"pixel_format", null, (int)0);
            ret = avformat.avformat_open_input((avformat.AVFormatContext)this.oc, (String)this.filename, (avformat.AVInputFormat)f, (avutil.AVDictionary)options);
            if (ret < 0) {
                throw new FrameGrabber.Exception("avformat_open_input() error " + ret + ": Could not open input \"" + this.filename + "\". (Has setFormat() been called?)");
            }
        }
        avutil.av_dict_free((avutil.AVDictionary)options);
        ret = avformat.avformat_find_stream_info((avformat.AVFormatContext)this.oc, (PointerPointer)null);
        if (ret < 0) {
            throw new FrameGrabber.Exception("avformat_find_stream_info() error " + ret + ": Could not find stream information.");
        }
        avformat.av_dump_format((avformat.AVFormatContext)this.oc, (int)0, (String)this.filename, (int)0);
        this.audio_st = null;
        this.video_st = null;
        avcodec.AVCodecParameters video_par = null;
        Object var5_5 = null;
        int nb_streams = this.oc.nb_streams();
        for (int i = 0; i < nb_streams; ++i) {
            avformat.AVStream st = this.oc.streams(i);
            avcodec.AVCodecParameters aVCodecParameters = st.codecpar();
            if (this.video_st == null && aVCodecParameters.codec_type() == 0 && (this.videoStream < 0 || this.videoStream == i)) {
                this.video_st = st;
                video_par = aVCodecParameters;
                continue;
            }
            if (this.audio_st != null || aVCodecParameters.codec_type() != 1 || this.audioStream >= 0 && this.audioStream != i) continue;
            this.audio_st = st;
            avcodec.AVCodecParameters aVCodecParameters2 = aVCodecParameters;
        }
        if (this.video_st == null && this.audio_st == null) {
            throw new FrameGrabber.Exception("Did not find a video or audio stream inside \"" + this.filename + "\" for videoStream == " + this.videoStream + " and audioStream == " + this.audioStream + ".");
        }
        if (this.video_st != null) {
            avcodec.AVCodec codec = avcodec.avcodec_find_decoder((int)video_par.codec_id());
            if (codec == null) {
                throw new FrameGrabber.Exception("avcodec_find_decoder() error: Unsupported video format or codec not found: " + video_par.codec_id() + ".");
            }
            this.video_c = avcodec.avcodec_alloc_context3((avcodec.AVCodec)codec);
            if (this.video_c == null) {
                throw new FrameGrabber.Exception("avcodec_alloc_context3() error: Could not allocate video decoding context.");
            }
            ret = avcodec.avcodec_parameters_to_context((avcodec.AVCodecContext)this.video_c, (avcodec.AVCodecParameters)this.video_st.codecpar());
            if (ret < 0) {
                this.release();
                throw new FrameGrabber.Exception("avcodec_parameters_to_context() error: Could not copy the video stream parameters.");
            }
            options = new avutil.AVDictionary(null);
            for (Map.Entry entry : this.videoOptions.entrySet()) {
                avutil.av_dict_set((avutil.AVDictionary)options, (String)((String)entry.getKey()), (String)((String)entry.getValue()), (int)0);
            }
            ret = avcodec.avcodec_open2((avcodec.AVCodecContext)this.video_c, (avcodec.AVCodec)codec, (avutil.AVDictionary)options);
            if (ret < 0) {
                throw new FrameGrabber.Exception("avcodec_open2() error " + ret + ": Could not open video codec.");
            }
            avutil.av_dict_free((avutil.AVDictionary)options);
            if (this.video_c.time_base().num() > 1000 && this.video_c.time_base().den() == 1) {
                this.video_c.time_base().den(1000);
            }
            if ((this.picture = avutil.av_frame_alloc()) == null) {
                throw new FrameGrabber.Exception("av_frame_alloc() error: Could not allocate raw picture frame.");
            }
            this.picture_rgb = avutil.av_frame_alloc();
            if (this.picture_rgb == null) {
                throw new FrameGrabber.Exception("av_frame_alloc() error: Could not allocate RGB picture frame.");
            }
            int width = this.imageWidth > 0 ? this.imageWidth : this.video_c.width();
            int n = this.imageHeight > 0 ? this.imageHeight : this.video_c.height();
            switch (this.imageMode) {
                case COLOR: 
                case GRAY: {
                    int fmt = this.getPixelFormat();
                    int size = avutil.av_image_get_buffer_size((int)fmt, (int)width, (int)n, (int)1);
                    this.image_ptr = new BytePointer[]{new BytePointer(avutil.av_malloc((long)size)).capacity((long)size)};
                    this.image_buf = new Buffer[]{this.image_ptr[0].asBuffer()};
                    avutil.av_image_fill_arrays((PointerPointer)new PointerPointer((Pointer)this.picture_rgb), (IntPointer)this.picture_rgb.linesize(), (BytePointer)this.image_ptr[0], (int)fmt, (int)width, (int)n, (int)1);
                    this.picture_rgb.format(fmt);
                    this.picture_rgb.width(width);
                    this.picture_rgb.height(n);
                    break;
                }
                case RAW: {
                    this.image_ptr = new BytePointer[]{null};
                    this.image_buf = new Buffer[]{null};
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        if (this.audio_st != null) {
            void var5_6;
            avcodec.AVCodec codec = avcodec.avcodec_find_decoder((int)var5_6.codec_id());
            if (codec == null) {
                throw new FrameGrabber.Exception("avcodec_find_decoder() error: Unsupported audio format or codec not found: " + var5_6.codec_id() + ".");
            }
            this.audio_c = avcodec.avcodec_alloc_context3((avcodec.AVCodec)codec);
            if (this.audio_c == null) {
                throw new FrameGrabber.Exception("avcodec_alloc_context3() error: Could not allocate audio decoding context.");
            }
            ret = avcodec.avcodec_parameters_to_context((avcodec.AVCodecContext)this.audio_c, (avcodec.AVCodecParameters)this.audio_st.codecpar());
            if (ret < 0) {
                this.release();
                throw new FrameGrabber.Exception("avcodec_parameters_to_context() error: Could not copy the audio stream parameters.");
            }
            options = new avutil.AVDictionary(null);
            for (Map.Entry entry : this.audioOptions.entrySet()) {
                avutil.av_dict_set((avutil.AVDictionary)options, (String)((String)entry.getKey()), (String)((String)entry.getValue()), (int)0);
            }
            ret = avcodec.avcodec_open2((avcodec.AVCodecContext)this.audio_c, (avcodec.AVCodec)codec, (avutil.AVDictionary)options);
            if (ret < 0) {
                throw new FrameGrabber.Exception("avcodec_open2() error " + ret + ": Could not open audio codec.");
            }
            avutil.av_dict_free((avutil.AVDictionary)options);
            this.samples_frame = avutil.av_frame_alloc();
            if (this.samples_frame == null) {
                throw new FrameGrabber.Exception("av_frame_alloc() error: Could not allocate audio frame.");
            }
        }
    }

    @Override
    public void stop() throws FrameGrabber.Exception {
        this.release();
    }

    @Override
    public void trigger() throws FrameGrabber.Exception {
        if (this.oc == null || this.oc.isNull()) {
            throw new FrameGrabber.Exception("Could not trigger: No AVFormatContext. (Has start() been called?)");
        }
        if (this.pkt2.size() > 0) {
            this.pkt2.size(0);
            avcodec.av_packet_unref((avcodec.AVPacket)this.pkt);
        }
        for (int i = 0; i < this.numBuffers + 1; ++i) {
            if (avformat.av_read_frame((avformat.AVFormatContext)this.oc, (avcodec.AVPacket)this.pkt) < 0) {
                return;
            }
            avcodec.av_packet_unref((avcodec.AVPacket)this.pkt);
        }
    }

    private void processImage() throws FrameGrabber.Exception {
        this.frame.imageWidth = this.imageWidth > 0 ? this.imageWidth : this.video_c.width();
        this.frame.imageHeight = this.imageHeight > 0 ? this.imageHeight : this.video_c.height();
        this.frame.imageDepth = 8;
        switch (this.imageMode) {
            case COLOR: 
            case GRAY: {
                if (this.deinterlace) {
                    throw new FrameGrabber.Exception("Cannot deinterlace: Functionality moved to FFmpegFrameFilter.");
                }
                this.img_convert_ctx = swscale.sws_getCachedContext((swscale.SwsContext)this.img_convert_ctx, (int)this.video_c.width(), (int)this.video_c.height(), (int)this.video_c.pix_fmt(), (int)this.frame.imageWidth, (int)this.frame.imageHeight, (int)this.getPixelFormat(), (int)2, null, null, (DoublePointer)null);
                if (this.img_convert_ctx == null) {
                    throw new FrameGrabber.Exception("sws_getCachedContext() error: Cannot initialize the conversion context.");
                }
                swscale.sws_scale((swscale.SwsContext)this.img_convert_ctx, (PointerPointer)new PointerPointer((Pointer)this.picture), (IntPointer)this.picture.linesize(), (int)0, (int)this.video_c.height(), (PointerPointer)new PointerPointer((Pointer)this.picture_rgb), (IntPointer)this.picture_rgb.linesize());
                this.frame.imageStride = this.picture_rgb.linesize(0);
                this.frame.image = this.image_buf;
                break;
            }
            case RAW: {
                this.frame.imageStride = this.picture.linesize(0);
                BytePointer ptr = this.picture.data(0);
                if (ptr != null && !ptr.equals((Object)this.image_ptr[0])) {
                    this.image_ptr[0] = ptr.capacity((long)(this.frame.imageHeight * this.frame.imageStride));
                    this.image_buf[0] = ptr.asBuffer();
                }
                this.frame.image = this.image_buf;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.frame.image[0].limit(this.frame.imageHeight * this.frame.imageStride);
        this.frame.imageChannels = this.frame.imageStride / this.frame.imageWidth;
    }

    @Override
    public Frame grab() throws FrameGrabber.Exception {
        return this.grabFrame(true, true, true, false);
    }

    public Frame grabImage() throws FrameGrabber.Exception {
        return this.grabFrame(false, true, true, false);
    }

    public Frame grabSamples() throws FrameGrabber.Exception {
        return this.grabFrame(true, false, true, false);
    }

    public Frame grabKeyFrame() throws FrameGrabber.Exception {
        return this.grabFrame(false, true, true, true);
    }

    public Frame grabFrame(boolean doAudio, boolean doVideo, boolean processImage, boolean keyFrames) throws FrameGrabber.Exception {
        if (this.oc == null || this.oc.isNull()) {
            throw new FrameGrabber.Exception("Could not grab: No AVFormatContext. (Has start() been called?)");
        }
        if (!(doVideo && this.video_st != null || doAudio && this.audio_st != null)) {
            return null;
        }
        this.frame.keyFrame = false;
        this.frame.imageWidth = 0;
        this.frame.imageHeight = 0;
        this.frame.imageDepth = 0;
        this.frame.imageChannels = 0;
        this.frame.imageStride = 0;
        this.frame.image = null;
        this.frame.sampleRate = 0;
        this.frame.audioChannels = 0;
        this.frame.samples = null;
        this.frame.opaque = null;
        if (doVideo && this.frameGrabbed) {
            this.frameGrabbed = false;
            if (processImage) {
                this.processImage();
            }
            this.frame.keyFrame = this.picture.key_frame() != 0;
            this.frame.image = this.image_buf;
            this.frame.opaque = this.picture;
            return this.frame;
        }
        boolean done = false;
        while (!done) {
            avutil.AVRational time_base;
            long pts;
            int len;
            if (this.pkt2.size() <= 0 && avformat.av_read_frame((avformat.AVFormatContext)this.oc, (avcodec.AVPacket)this.pkt) < 0) {
                if (doVideo && this.video_st != null) {
                    this.pkt.stream_index(this.video_st.index());
                    this.pkt.flags(1);
                    this.pkt.data(null);
                    this.pkt.size(0);
                } else {
                    return null;
                }
            }
            if (doVideo && this.video_st != null && this.pkt.stream_index() == this.video_st.index() && (!keyFrames || this.pkt.flags() == 1)) {
                len = avcodec.avcodec_decode_video2((avcodec.AVCodecContext)this.video_c, (avutil.AVFrame)this.picture, (int[])this.got_frame, (avcodec.AVPacket)this.pkt);
                if (!(len < 0 || this.got_frame[0] == 0 || keyFrames && this.picture.pict_type() != 1)) {
                    pts = avutil.av_frame_get_best_effort_timestamp((avutil.AVFrame)this.picture);
                    time_base = this.video_st.time_base();
                    this.timestamp = 1000000L * pts * (long)time_base.num() / (long)time_base.den();
                    this.frameNumber = (int)((double)this.timestamp * this.getFrameRate() / 1000000.0);
                    if (processImage) {
                        this.processImage();
                    }
                    done = true;
                    this.frame.keyFrame = this.picture.key_frame() != 0;
                    this.frame.image = this.image_buf;
                    this.frame.opaque = this.picture;
                } else if (this.pkt.data() == null && this.pkt.size() == 0) {
                    return null;
                }
            } else if (doAudio && this.audio_st != null && this.pkt.stream_index() == this.audio_st.index()) {
                if (this.pkt2.size() <= 0) {
                    BytePointer.memcpy((Pointer)this.pkt2, (Pointer)this.pkt, (long)this.sizeof_pkt);
                }
                avutil.av_frame_unref((avutil.AVFrame)this.samples_frame);
                len = avcodec.avcodec_decode_audio4((avcodec.AVCodecContext)this.audio_c, (avutil.AVFrame)this.samples_frame, (int[])this.got_frame, (avcodec.AVPacket)this.pkt2);
                if (len <= 0) {
                    this.pkt2.size(0);
                } else {
                    this.pkt2.data(this.pkt2.data().position((long)len));
                    this.pkt2.size(this.pkt2.size() - len);
                    if (this.got_frame[0] != 0) {
                        pts = avutil.av_frame_get_best_effort_timestamp((avutil.AVFrame)this.samples_frame);
                        time_base = this.audio_st.time_base();
                        this.timestamp = 1000000L * pts * (long)time_base.num() / (long)time_base.den();
                        done = true;
                        int sample_format = this.samples_frame.format();
                        int planes = avutil.av_sample_fmt_is_planar((int)sample_format) != 0 ? this.samples_frame.channels() : 1;
                        int data_size = avutil.av_samples_get_buffer_size((IntPointer)null, (int)this.audio_c.channels(), (int)this.samples_frame.nb_samples(), (int)this.audio_c.sample_fmt(), (int)1) / planes;
                        if (this.samples_buf == null || this.samples_buf.length != planes) {
                            this.samples_ptr = new BytePointer[planes];
                            this.samples_buf = new Buffer[planes];
                        }
                        this.frame.keyFrame = this.samples_frame.key_frame() != 0;
                        this.frame.sampleRate = this.audio_c.sample_rate();
                        this.frame.audioChannels = this.audio_c.channels();
                        this.frame.samples = this.samples_buf;
                        this.frame.opaque = this.samples_frame;
                        int sample_size = data_size / avutil.av_get_bytes_per_sample((int)sample_format);
                        for (int i = 0; i < planes; ++i) {
                            BytePointer p = this.samples_frame.data(i);
                            if (!p.equals((Object)this.samples_ptr[i]) || this.samples_ptr[i].capacity() < (long)data_size) {
                                this.samples_ptr[i] = p.capacity((long)data_size);
                                ByteBuffer b = p.asBuffer();
                                switch (sample_format) {
                                    case 0: 
                                    case 5: {
                                        this.samples_buf[i] = b;
                                        break;
                                    }
                                    case 1: 
                                    case 6: {
                                        this.samples_buf[i] = b.asShortBuffer();
                                        break;
                                    }
                                    case 2: 
                                    case 7: {
                                        this.samples_buf[i] = b.asIntBuffer();
                                        break;
                                    }
                                    case 3: 
                                    case 8: {
                                        this.samples_buf[i] = b.asFloatBuffer();
                                        break;
                                    }
                                    case 4: 
                                    case 9: {
                                        this.samples_buf[i] = b.asDoubleBuffer();
                                        break;
                                    }
                                    default: {
                                        assert (false);
                                        break;
                                    }
                                }
                            }
                            this.samples_buf[i].position(0).limit(sample_size);
                        }
                    }
                }
            }
            if (this.pkt2.size() > 0) continue;
            avcodec.av_packet_unref((avcodec.AVPacket)this.pkt);
        }
        return this.frame;
    }

    public avcodec.AVPacket grabPacket() throws FrameGrabber.Exception {
        if (this.oc == null || this.oc.isNull()) {
            throw new FrameGrabber.Exception("Could not trigger: No AVFormatContext. (Has start() been called?)");
        }
        if (avformat.av_read_frame((avformat.AVFormatContext)this.oc, (avcodec.AVPacket)this.pkt) < 0) {
            return null;
        }
        return this.pkt;
    }

    static {
        try {
            FFmpegFrameGrabber.tryLoad();
        }
        catch (FrameGrabber.Exception exception) {
            // empty catch block
        }
        inputStreams = new HashMap();
    }

    static class ReadCallback
    extends avformat.Read_packet_Pointer_BytePointer_int {
        ReadCallback() {
        }

        public int call(Pointer opaque, BytePointer buf, int buf_size) {
            try {
                byte[] b = new byte[buf_size];
                InputStream is = inputStreams.get(opaque);
                int size = is.read(b, 0, buf_size);
                if (size < 0) {
                    return 0;
                }
                buf.put(b, 0, size);
                return size;
            }
            catch (Throwable t) {
                System.err.println("Error on InputStream.read(): " + t);
                return -1;
            }
        }
    }

    static class SeekCallback
    extends avformat.Seek_Pointer_long_int {
        SeekCallback() {
        }

        public long call(Pointer opaque, long offset, int whence) {
            try {
                InputStream is = inputStreams.get(opaque);
                switch (whence) {
                    case 0: {
                        is.reset();
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        return -1L;
                    }
                }
                is.skip(offset);
                return 0L;
            }
            catch (Throwable t) {
                System.err.println("Error on InputStream.reset() or skip(): " + t);
                return -1L;
            }
        }
    }
}

