/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.pose;

import boofcv.abst.geo.RefinePnP;
import boofcv.abst.geo.optimization.ResidualsCodecToMatrix;
import boofcv.alg.geo.pose.PnPJacobianRodrigues;
import boofcv.alg.geo.pose.PnPResidualReprojection;
import boofcv.alg.geo.pose.PnPRodriguesCodec;
import boofcv.struct.geo.Point2D3D;
import georegression.struct.se.Se3_F64;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelCodec;
import org.ddogleg.optimization.FactoryOptimization;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.functions.FunctionNtoMxN;

public class PnPRefineRodrigues
implements RefinePnP {
    ModelCodec<Se3_F64> paramModel = new PnPRodriguesCodec();
    ResidualsCodecToMatrix<Se3_F64, Point2D3D> func;
    PnPJacobianRodrigues jacobian = new PnPJacobianRodrigues();
    double[] param;
    UnconstrainedLeastSquares minimizer;
    int maxIterations;
    double convergenceTol;

    public PnPRefineRodrigues(double convergenceTol, int maxIterations) {
        this.maxIterations = maxIterations;
        this.convergenceTol = convergenceTol;
        this.minimizer = FactoryOptimization.leastSquareLevenberg((double)0.001);
        this.func = new ResidualsCodecToMatrix<Se3_F64, Point2D3D>(this.paramModel, new PnPResidualReprojection(), new Se3_F64());
        this.param = new double[this.paramModel.getParamLength()];
    }

    public boolean fitModel(List<Point2D3D> obs, Se3_F64 worldToCamera, Se3_F64 refinedWorldToCamera) {
        this.paramModel.encode((Object)worldToCamera, this.param);
        this.func.setObservations(obs);
        this.jacobian.setObservations(obs);
        this.minimizer.setFunction(this.func, (FunctionNtoMxN)this.jacobian);
        this.minimizer.initialize(this.param, 0.0, this.convergenceTol * (double)obs.size());
        boolean updated = false;
        for (int i = 0; i < this.maxIterations; ++i) {
            boolean converged = this.minimizer.iterate();
            if (converged || this.minimizer.isUpdated()) {
                this.paramModel.decode(this.minimizer.getParameters(), (Object)refinedWorldToCamera);
                updated = true;
            }
            if (!converged) continue;
            if (i != 0) break;
            refinedWorldToCamera.set(worldToCamera);
            break;
        }
        return updated;
    }
}

