/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.radtan;

import boofcv.alg.distort.radtan.RadialTangential_F64;
import boofcv.alg.distort.radtan.RemoveRadialNtoN_F64;
import boofcv.struct.distort.Point2Transform2_F64;
import georegression.misc.GrlConstants;
import georegression.struct.point.Point2D_F64;

public class RemoveRadialPtoN_F64
implements Point2Transform2_F64 {
    protected double cx;
    protected double cy;
    protected double fx;
    protected double fy;
    protected double skew;
    protected RadialTangential_F64 params;
    private double a11;
    private double a12;
    private double a13;
    private double a22;
    private double a23;
    private double tol = GrlConstants.DCONV_TOL_A;

    public RemoveRadialPtoN_F64() {
    }

    public RemoveRadialPtoN_F64(double tol) {
        this.tol = tol;
    }

    public void setTolerance(double tol) {
        this.tol = tol;
    }

    public RemoveRadialPtoN_F64 setK(double fx, double fy, double skew, double cx, double cy) {
        this.fx = fx;
        this.fy = fy;
        this.skew = skew;
        this.cx = cx;
        this.cy = cy;
        this.a11 = 1.0 / fx;
        this.a12 = -skew / (fx * fy);
        this.a13 = (skew * cy - cx * fy) / (fx * fy);
        this.a22 = 1.0 / fy;
        this.a23 = -cy / fy;
        return this;
    }

    public RemoveRadialPtoN_F64 setDistortion(double[] radial, double t1, double t2) {
        this.params = new RadialTangential_F64(radial, t1, t2);
        return this;
    }

    public void compute(double x, double y, Point2D_F64 out) {
        out.x = this.a11 * x + this.a12 * y + this.a13;
        out.y = this.a22 * y + this.a23;
        RemoveRadialNtoN_F64.removeRadial(out.x, out.y, this.params.radial, this.params.t1, this.params.t2, out, this.tol);
    }
}

