/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.spherical;

import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.LensDistortionWideFOV;
import boofcv.alg.distort.PixelTransformCached_F32;
import boofcv.alg.distort.PointToPixelTransform_F32;
import boofcv.alg.distort.spherical.EquirectangularTools_F32;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.alg.misc.GPixelMath;
import boofcv.alg.misc.PixelMath;
import boofcv.struct.distort.PixelTransform2_F32;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.distort.Point2Transform3_F32;
import boofcv.struct.distort.Point3Transform2_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import georegression.geometry.GeometryMath_F32;
import georegression.geometry.UtilVector3D_F32;
import georegression.metric.UtilAngle;
import georegression.struct.GeoTuple3D_F32;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point3D_F32;
import georegression.struct.se.Se3_F32;
import java.util.ArrayList;
import java.util.List;
import org.ejml.data.FMatrixRMaj;

public class MultiCameraToEquirectangular<T extends ImageBase<T>> {
    private EquirectangularTools_F32 tools = new EquirectangularTools_F32();
    private int equiWidth;
    private int equHeight;
    List<Camera> cameras = new ArrayList<Camera>();
    private T averageImage;
    private T workImage;
    private T cameraRendered;
    private GrayF32 weightImage;
    private ImageDistort<T, T> distort;
    private float maskToleranceAngle = UtilAngle.radian((float)0.1f);

    public MultiCameraToEquirectangular(ImageDistort<T, T> distort, int equiWidth, int equiHeight, ImageType<T> imageType) {
        if (imageType.getDataType().isInteger() || imageType.getDataType().getNumBits() != 32) {
            throw new IllegalArgumentException("Must be a 32 bit floating point image");
        }
        this.distort = distort;
        this.equiWidth = equiWidth;
        this.equHeight = equiHeight;
        this.tools.configure(equiWidth, equiHeight);
        this.weightImage = new GrayF32(equiWidth, equiHeight);
        this.averageImage = imageType.createImage(equiWidth, equiHeight);
        this.workImage = this.averageImage.createSameShape();
        this.cameraRendered = this.averageImage.createSameShape();
    }

    public void addCamera(Se3_F32 cameraToCommon, LensDistortionWideFOV factory, int width, int height) {
        Point2Transform3_F32 p2s = factory.undistortPtoS_F32();
        Point3Transform2_F32 s2p = factory.distortStoP_F32();
        EquiToCamera equiToCamera = new EquiToCamera(cameraToCommon.getR(), s2p);
        GrayF32 equiMask = new GrayF32(this.equiWidth, this.equHeight);
        PixelTransformCached_F32 transformEquiToCam = new PixelTransformCached_F32(this.equiWidth, this.equHeight, (PixelTransform2_F32)new PointToPixelTransform_F32((Point2Transform2_F32)equiToCamera));
        Point3D_F32 p3b = new Point3D_F32();
        Point2D_F32 p2 = new Point2D_F32();
        for (int row = 0; row < this.equHeight; ++row) {
            for (int col = 0; col < this.equiWidth; ++col) {
                double angle;
                equiToCamera.compute(col, row, p2);
                int camX = (int)(p2.x + 0.5f);
                int camY = (int)(p2.y + 0.5f);
                if (Double.isNaN(p2.x) || Double.isNaN(p2.y) || camX < 0 || camY < 0 || camX >= width || camY >= height) continue;
                p2s.compute(p2.x, p2.y, p3b);
                if (Double.isNaN(p3b.x) || Double.isNaN(p3b.y) || Double.isNaN(p3b.z) || !((angle = (double)UtilVector3D_F32.acute((GeoTuple3D_F32)equiToCamera.unitCam, (GeoTuple3D_F32)p3b)) < (double)this.maskToleranceAngle)) continue;
                equiMask.set(col, row, 1.0f);
            }
        }
        this.cameras.add(new Camera(equiMask, (PixelTransform2_F32)transformEquiToCam));
    }

    public void addCamera(Se3_F32 cameraToCommon, LensDistortionWideFOV factory, GrayU8 camMask) {
        Point2Transform3_F32 p2s = factory.undistortPtoS_F32();
        Point3Transform2_F32 s2p = factory.distortStoP_F32();
        EquiToCamera equiToCamera = new EquiToCamera(cameraToCommon.getR(), s2p);
        GrayF32 equiMask = new GrayF32(this.equiWidth, this.equHeight);
        PixelTransformCached_F32 transformEquiToCam = new PixelTransformCached_F32(this.equiWidth, this.equHeight, (PixelTransform2_F32)new PointToPixelTransform_F32((Point2Transform2_F32)equiToCamera));
        int width = camMask.width;
        int height = camMask.height;
        Point3D_F32 p3b = new Point3D_F32();
        Point2D_F32 p2 = new Point2D_F32();
        for (int row = 0; row < this.equHeight; ++row) {
            for (int col = 0; col < this.equiWidth; ++col) {
                double angle;
                equiToCamera.compute(col, row, p2);
                int camX = (int)(p2.x + 0.5f);
                int camY = (int)(p2.y + 0.5f);
                if (Double.isNaN(p2.x) || Double.isNaN(p2.y) || camX < 0 || camY < 0 || camX >= width || camY >= height || camMask.unsafe_get(camX, camY) != 1) continue;
                p2s.compute(p2.x, p2.y, p3b);
                if (Double.isNaN(p3b.x) || Double.isNaN(p3b.y) || Double.isNaN(p3b.z) || !((angle = (double)UtilVector3D_F32.acute((GeoTuple3D_F32)equiToCamera.unitCam, (GeoTuple3D_F32)p3b)) < (double)this.maskToleranceAngle)) continue;
                equiMask.set(col, row, 1.0f);
            }
        }
        this.cameras.add(new Camera(equiMask, (PixelTransform2_F32)transformEquiToCam));
    }

    public void render(List<T> cameraImages) {
        if (cameraImages.size() != this.cameras.size()) {
            throw new IllegalArgumentException("Input camera image count doesn't equal the expected number");
        }
        GImageMiscOps.fill((ImageBase)this.weightImage, (double)1.0E-4);
        GImageMiscOps.fill(this.averageImage, (double)0.0);
        for (int i = 0; i < this.cameras.size(); ++i) {
            Camera c = this.cameras.get(i);
            ImageBase cameraImage = (ImageBase)cameraImages.get(i);
            this.distort.setModel(c.equiToCamera);
            this.distort.apply(cameraImage, this.cameraRendered);
            PixelMath.add((GrayF32)this.weightImage, (GrayF32)c.mask, (GrayF32)this.weightImage);
            GPixelMath.multiply((ImageBase)c.mask, this.cameraRendered, this.workImage);
            GPixelMath.add(this.workImage, this.averageImage, this.averageImage);
        }
        GPixelMath.divide(this.averageImage, (ImageBase)this.weightImage, this.averageImage);
    }

    public T getRenderedImage() {
        return this.averageImage;
    }

    public GrayF32 getMask(int which) {
        return this.cameras.get((int)which).mask;
    }

    public float getMaskToleranceAngle() {
        return this.maskToleranceAngle;
    }

    public void setMaskToleranceAngle(float maskToleranceAngle) {
        this.maskToleranceAngle = maskToleranceAngle;
    }

    private class EquiToCamera
    implements Point2Transform2_F32 {
        FMatrixRMaj cameraToCommon;
        Point3Transform2_F32 s2p;
        Point3D_F32 unitCam = new Point3D_F32();
        Point3D_F32 unitCommon = new Point3D_F32();

        EquiToCamera(FMatrixRMaj cameraToCommon, Point3Transform2_F32 s2p) {
            this.cameraToCommon = cameraToCommon;
            this.s2p = s2p;
        }

        public void compute(float x, float y, Point2D_F32 out) {
            MultiCameraToEquirectangular.this.tools.equiToNormFV(x, y, this.unitCommon);
            GeometryMath_F32.multTran((FMatrixRMaj)this.cameraToCommon, (GeoTuple3D_F32)this.unitCommon, (GeoTuple3D_F32)this.unitCam);
            this.s2p.compute(this.unitCam.x, this.unitCam.y, this.unitCam.z, out);
        }
    }

    static class Camera {
        GrayF32 mask;
        PixelTransform2_F32 equiToCamera;

        public Camera(GrayF32 mask, PixelTransform2_F32 equiToCamera) {
            this.mask = mask;
            this.equiToCamera = equiToCamera;
        }
    }
}

